"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    fleet_id: str,
    instance_id: str = None,
    limit: int = None,
    next_token: str = None,
    location: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a fleet's instances, including instance IDs, connection data, and status.  This operation can be used in the following ways:   To get information on all instances that are deployed to a fleet's home Region, provide the fleet ID.   To get information on all instances that are deployed to a fleet's remote location, provide the fleet ID and location name.   To get information on a specific instance in a fleet, provide the fleet ID and instance ID.   Use the pagination parameters to retrieve results as a set of sequential pages.  If successful, an Instance object is returned for each requested instance. Instances are not returned in any particular order.   Learn more   Remotely Access Fleet Instances   Debug Fleet Issues   Related actions   DescribeInstances | GetInstanceAccess | DescribeEC2InstanceLimits | All APIs by task

    Args:
        fleet_id(str): A unique identifier for the fleet to retrieve instance information for. You can use either the fleet ID or ARN value.
        instance_id(str, optional): A unique identifier for an instance to retrieve. Specify an instance ID or leave blank to retrieve all instances in the fleet. Defaults to None.
        limit(int, optional): The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. Defaults to None.
        next_token(str, optional): A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. Defaults to None.
        location(str, optional): The name of a location to retrieve instance information for, in the form of an AWS Region code such as us-west-2. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.instance.init.describe_all(ctx, fleet_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.instance.init.describe_all fleet_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="describe_instances",
        op_kwargs={
            "FleetId": fleet_id,
            "InstanceId": instance_id,
            "Limit": limit,
            "NextToken": next_token,
            "Location": location,
        },
    )
