"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    timeout_in_seconds: int = None,
    player_latency_policies: List = None,
    destinations: List = None,
    filter_configuration: Dict = None,
    priority_configuration: Dict = None,
    custom_event_data: str = None,
    notification_target: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a placement queue that processes requests for new game sessions. A queue uses FleetIQ algorithms to determine the best placement locations and find an available game server there, then prompts the game server process to start a new game session.  A game session queue is configured with a set of destinations (GameLift fleets or aliases), which determine the locations where the queue can place new game sessions. These destinations can span multiple fleet types (Spot and On-Demand), instance types, and AWS Regions. If the queue includes multi-location fleets, the queue is able to place game sessions in all of a fleet's remote locations. You can opt to filter out individual locations if needed. The queue configuration also determines how FleetIQ selects the best available placement for a new game session. Before searching for an available game server, FleetIQ first prioritizes the queue's destinations and locations, with the best placement locations on top. You can set up the queue to use the FleetIQ default prioritization or provide an alternate set of priorities. To create a new queue, provide a name, timeout value, and a list of destinations. Optionally, specify a sort configuration and/or a filter, and define a set of latency cap policies. You can also include the ARN for an Amazon Simple Notification Service (SNS) topic to receive notifications of game session placement activity. Notifications using SNS or CloudWatch events is the preferred way to track placement activity. If successful, a new GameSessionQueue object is returned with an assigned queue ARN. New game session requests, which are submitted to the queue with StartGameSessionPlacement or StartMatchmaking, reference a queue's name or ARN.   Learn more    Design a game session queue    Create a game session queue   Related actions   CreateGameSessionQueue | DescribeGameSessionQueues | UpdateGameSessionQueue | DeleteGameSessionQueue | All APIs by task

    Args:
        name(str): A descriptive label that is associated with game session queue. Queue names must be unique within each Region.
        timeout_in_seconds(int, optional): The maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a TIMED_OUT status. Defaults to None.
        player_latency_policies(List, optional): A set of policies that act as a sliding cap on player latency. FleetIQ works to deliver low latency for most players in a game session. These policies ensure that no individual player can be placed into a game with unreasonably high latency. Use multiple policies to gradually relax latency requirements a step at a time. Multiple policies are applied based on their maximum allowed latency, starting with the lowest value. Defaults to None.
        destinations(List, optional): A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue. Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference. Defaults to None.
        filter_configuration(Dict, optional): A list of locations where a queue is allowed to place new game sessions. Locations are specified in the form of AWS Region codes, such as us-west-2. If this parameter is not set, game sessions can be placed in any queue location. . Defaults to None.
        priority_configuration(Dict, optional): Custom settings to use when prioritizing destinations and locations for game session placements. This configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly named will be automatically applied at the end of the prioritization process. . Defaults to None.
        custom_event_data(str, optional):  Information to be added to all events that are related to this game session queue. . Defaults to None.
        notification_target(str, optional): An SNS topic ARN that is set up to receive game session placement notifications. See  Setting up notifications for game session placement. Defaults to None.
        tags(List, optional): A list of labels to assign to the new game session queue resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see  Tagging AWS Resources in the AWS General Reference. Once the resource is created, you can use TagResource, UntagResource, and ListTagsForResource to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.game.session.queue.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.game.session.queue.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="create_game_session_queue",
        op_kwargs={
            "Name": name,
            "TimeoutInSeconds": timeout_in_seconds,
            "PlayerLatencyPolicies": player_latency_policies,
            "Destinations": destinations,
            "FilterConfiguration": filter_configuration,
            "PriorityConfiguration": priority_configuration,
            "CustomEventData": custom_event_data,
            "NotificationTarget": notification_target,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a game session queue. Once a queue is successfully deleted, unfulfilled StartGameSessionPlacement requests that reference the queue will fail. To delete a queue, specify the queue name.  Learn more    Using Multi-Region Queues   Related actions   CreateGameSessionQueue | DescribeGameSessionQueues | UpdateGameSessionQueue | DeleteGameSessionQueue | All APIs by task

    Args:
        name(str): A descriptive label that is associated with game session queue. Queue names must be unique within each Region. You can use either the queue ID or ARN value. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.game.session.queue.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.game.session.queue.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="delete_game_session_queue",
        op_kwargs={"Name": name},
    )


async def describe_all(
    hub, ctx, names: List = None, limit: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the properties for one or more game session queues. When requesting multiple queues, use the pagination parameters to retrieve results as a set of sequential pages. If successful, a GameSessionQueue object is returned for each requested queue. When specifying a list of queues, objects are returned only for queues that currently exist in the Region.  Learn more    View Your Queues   Related actions   CreateGameSessionQueue | DescribeGameSessionQueues | UpdateGameSessionQueue | DeleteGameSessionQueue | All APIs by task

    Args:
        names(List, optional): A list of queue names to retrieve information for. You can use either the queue ID or ARN value. To request settings for all queues, leave this parameter empty. . Defaults to None.
        limit(int, optional): The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. You can request up to 50 results. Defaults to None.
        next_token(str, optional): A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.game.session.queue.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.game.session.queue.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="describe_game_session_queues",
        op_kwargs={"Names": names, "Limit": limit, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    name: str,
    timeout_in_seconds: int = None,
    player_latency_policies: List = None,
    destinations: List = None,
    filter_configuration: Dict = None,
    priority_configuration: Dict = None,
    custom_event_data: str = None,
    notification_target: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the configuration of a game session queue, which determines how the queue processes new game session requests. To update settings, specify the queue name to be updated and provide the new settings. When updating destinations, provide a complete list of destinations.   Learn more    Using Multi-Region Queues   Related actions   CreateGameSessionQueue | DescribeGameSessionQueues | UpdateGameSessionQueue | DeleteGameSessionQueue | All APIs by task

    Args:
        name(str): A descriptive label that is associated with game session queue. Queue names must be unique within each Region. You can use either the queue ID or ARN value. .
        timeout_in_seconds(int, optional): The maximum time, in seconds, that a new game session placement request remains in the queue. When a request exceeds this time, the game session placement changes to a TIMED_OUT status. Defaults to None.
        player_latency_policies(List, optional): A set of policies that act as a sliding cap on player latency. FleetIQ works to deliver low latency for most players in a game session. These policies ensure that no individual player can be placed into a game with unreasonably high latency. Use multiple policies to gradually relax latency requirements a step at a time. Multiple policies are applied based on their maximum allowed latency, starting with the lowest value. When updating policies, provide a complete collection of policies. Defaults to None.
        destinations(List, optional): A list of fleets and/or fleet aliases that can be used to fulfill game session placement requests in the queue. Destinations are identified by either a fleet ARN or a fleet alias ARN, and are listed in order of placement preference. When updating this list, provide a complete list of destinations. Defaults to None.
        filter_configuration(Dict, optional): A list of locations where a queue is allowed to place new game sessions. Locations are specified in the form of AWS Region codes, such as us-west-2. If this parameter is not set, game sessions can be placed in any queue location. To remove an existing filter configuration, pass in an empty set. Defaults to None.
        priority_configuration(Dict, optional): Custom settings to use when prioritizing destinations and locations for game session placements. This configuration replaces the FleetIQ default prioritization process. Priority types that are not explicitly named will be automatically applied at the end of the prioritization process. To remove an existing priority configuration, pass in an empty set. Defaults to None.
        custom_event_data(str, optional):  Information to be added to all events that are related to this game session queue. . Defaults to None.
        notification_target(str, optional): An SNS topic ARN that is set up to receive game session placement notifications. See  Setting up notifications for game session placement. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.game.session.queue.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.game.session.queue.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="update_game_session_queue",
        op_kwargs={
            "Name": name,
            "TimeoutInSeconds": timeout_in_seconds,
            "PlayerLatencyPolicies": player_latency_policies,
            "Destinations": destinations,
            "FilterConfiguration": filter_configuration,
            "PriorityConfiguration": priority_configuration,
            "CustomEventData": custom_event_data,
            "NotificationTarget": notification_target,
        },
    )
