"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, placement_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information, including current status, about a game session placement request.  To get game session placement details, specify the placement ID. If successful, a GameSessionPlacement object is returned.  Related actions   CreateGameSession | DescribeGameSessions | DescribeGameSessionDetails | SearchGameSessions | UpdateGameSession | GetGameSessionLogUrl | StartGameSessionPlacement | DescribeGameSessionPlacement | StopGameSessionPlacement | All APIs by task

    Args:
        placement_id(str): A unique identifier for a game session placement to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.game.session.placement.describe(
                ctx, placement_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.game.session.placement.describe placement_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="describe_game_session_placement",
        op_kwargs={"PlacementId": placement_id},
    )


async def start(
    hub,
    ctx,
    placement_id: str,
    game_session_queue_name: str,
    maximum_player_session_count: int,
    game_properties: List = None,
    game_session_name: str = None,
    player_latencies: List = None,
    desired_player_sessions: List = None,
    game_session_data: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Places a request for a new game session in a queue (see CreateGameSessionQueue). When processing a placement request, Amazon GameLift searches for available resources on the queue's destinations, scanning each until it finds resources or the placement request times out. A game session placement request can also request player sessions. When a new game session is successfully created, Amazon GameLift creates a player session for each player included in the request. When placing a game session, by default Amazon GameLift tries each fleet in the order they are listed in the queue configuration. Ideally, a queue's destinations are listed in preference order. Alternatively, when requesting a game session with players, you can also provide latency data for each player in relevant Regions. Latency data indicates the performance lag a player experiences when connected to a fleet in the Region. Amazon GameLift uses latency data to reorder the list of destinations to place the game session in a Region with minimal lag. If latency data is provided for multiple players, Amazon GameLift calculates each Region's average lag for all players and reorders to get the best game play across all players.  To place a new game session request, specify the following:   The queue name and a set of game session properties and settings   A unique ID (such as a UUID) for the placement. You use this ID to track the status of the placement request   (Optional) A set of player data and a unique player ID for each player that you are joining to the new game session (player data is optional, but if you include it, you must also provide a unique ID for each player)   Latency data for all players (if you want to optimize game play for the players)   If successful, a new game session placement is created. To track the status of a placement request, call DescribeGameSessionPlacement and check the request's status. If the status is FULFILLED, a new game session has been created and a game session ARN and Region are referenced. If the placement request times out, you can resubmit the request or retry it with a different queue.   Related actions   CreateGameSession | DescribeGameSessions | DescribeGameSessionDetails | SearchGameSessions | UpdateGameSession | GetGameSessionLogUrl | StartGameSessionPlacement | DescribeGameSessionPlacement | StopGameSessionPlacement | All APIs by task

    Args:
        placement_id(str): A unique identifier to assign to the new game session placement. This value is developer-defined. The value must be unique across all Regions and cannot be reused unless you are resubmitting a canceled or timed-out placement request.
        game_session_queue_name(str): Name of the queue to use to place the new game session. You can use either the queue name or ARN value. .
        game_properties(List, optional): A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the GameSession object with a request to start a new game session (see Start a Game Session). Defaults to None.
        maximum_player_session_count(int): The maximum number of players that can be connected simultaneously to the game session.
        game_session_name(str, optional): A descriptive label that is associated with a game session. Session names do not need to be unique. Defaults to None.
        player_latencies(List, optional): A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when connected to AWS Regions. This information is used to try to place the new game session where it can offer the best possible gameplay experience for the players. . Defaults to None.
        desired_player_sessions(List, optional): Set of information on each player to create a player session for. Defaults to None.
        game_session_data(str, optional): A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the GameSession object with a request to start a new game session (see Start a Game Session). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.game.session.placement.start(
                ctx,
                placement_id=value,
                game_session_queue_name=value,
                maximum_player_session_count=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.game.session.placement.start placement_id=value, game_session_queue_name=value, maximum_player_session_count=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="start_game_session_placement",
        op_kwargs={
            "PlacementId": placement_id,
            "GameSessionQueueName": game_session_queue_name,
            "GameProperties": game_properties,
            "MaximumPlayerSessionCount": maximum_player_session_count,
            "GameSessionName": game_session_name,
            "PlayerLatencies": player_latencies,
            "DesiredPlayerSessions": desired_player_sessions,
            "GameSessionData": game_session_data,
        },
    )


async def stop(hub, ctx, placement_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels a game session placement that is in PENDING status. To stop a placement, provide the placement ID values. If successful, the placement is moved to CANCELLED status.  Related actions   CreateGameSession | DescribeGameSessions | DescribeGameSessionDetails | SearchGameSessions | UpdateGameSession | GetGameSessionLogUrl | StartGameSessionPlacement | DescribeGameSessionPlacement | StopGameSessionPlacement | All APIs by task

    Args:
        placement_id(str): A unique identifier for a game session placement to cancel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.game.session.placement.stop(ctx, placement_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.game.session.placement.stop placement_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="stop_game_session_placement",
        op_kwargs={"PlacementId": placement_id},
    )
