"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, game_session_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the location of stored game session logs for a specified game session. When a game session is terminated, GameLift automatically stores the logs in Amazon S3 and retains them for 14 days. Use this URL to download the logs.  See the AWS Service Limits page for maximum log file sizes. Log files that exceed this limit are not saved.   Related actions   CreateGameSession | DescribeGameSessions | DescribeGameSessionDetails | SearchGameSessions | UpdateGameSession | GetGameSessionLogUrl | StartGameSessionPlacement | DescribeGameSessionPlacement | StopGameSessionPlacement | All APIs by task

    Args:
        game_session_id(str): A unique identifier for the game session to get logs for. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.game.session.log_url.get(ctx, game_session_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.game.session.log_url.get game_session_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="get_game_session_log_url",
        op_kwargs={"GameSessionId": game_session_id},
    )
