"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    maximum_player_session_count: int,
    fleet_id: str = None,
    alias_id: str = None,
    name: str = None,
    game_properties: List = None,
    creator_id: str = None,
    game_session_id: str = None,
    idempotency_token: str = None,
    game_session_data: str = None,
    location: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a multiplayer game session for players in a specific fleet location. This operation prompts an available server process to start a game session and retrieves connection information for the new game session. As an alternative, consider using the GameLift game session placement feature with  with StartGameSessionPlacement, which uses FleetIQ algorithms and queues to optimize the placement process. When creating a game session, you specify exactly where you want to place it and provide a set of game session configuration settings. The fleet must be in ACTIVE status before a game session can be created in it.  This operation can be used in the following ways:    To create a game session on an instance in a fleet's home Region, provide a fleet or alias ID along with your game session configuration.    To create a game session on an instance in a fleet's remote location, provide a fleet or alias ID and a location name, along with your game session configuration.    If successful, a workflow is initiated to start a new game session. A GameSession object is returned containing the game session configuration and status. When the status is ACTIVE, game session connection information is provided and player sessions can be created for the game session. By default, newly created game sessions are open to new players. You can restrict new player access by using UpdateGameSession to change the game session's player session creation policy. Game session logs are retained for all active game sessions for 14 days. To access the logs, call GetGameSessionLogUrl to download the log files.  Available in GameLift Local.   Learn more   Start a game session   Related actions   CreateGameSession | DescribeGameSessions | DescribeGameSessionDetails | SearchGameSessions | UpdateGameSession | GetGameSessionLogUrl | StartGameSessionPlacement | DescribeGameSessionPlacement | StopGameSessionPlacement | All APIs by task

    Args:
        fleet_id(str, optional): A unique identifier for the fleet to create a game session in. You can use either the fleet ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both. Defaults to None.
        alias_id(str, optional): A unique identifier for the alias associated with the fleet to create a game session in. You can use either the alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both. Defaults to None.
        maximum_player_session_count(int): The maximum number of players that can be connected simultaneously to the game session.
        name(str, optional): A descriptive label that is associated with a game session. Session names do not need to be unique. Defaults to None.
        game_properties(List, optional): A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a game server process in the GameSession object with a request to start a new game session. Defaults to None.
        creator_id(str, optional): A unique identifier for a player or entity creating the game session. This parameter is required when requesting a new game session on a fleet with a resource creation limit policy. This type of policy limits the number of concurrent active game sessions that one player can create within a certain time span. GameLift uses the CreatorId to evaluate the new request against the policy. Defaults to None.
        game_session_id(str, optional):  This parameter is no longer preferred. Please use IdempotencyToken instead. Custom string that uniquely identifies a request for a new game session. Maximum token length is 48 characters. If provided, this string is included in the new game session's ID. Defaults to None.
        idempotency_token(str, optional): Custom string that uniquely identifies the new game session request. This is useful for ensuring that game session requests with the same idempotency token are processed only once. Subsequent requests with the same string return the original GameSession object, with an updated status. Maximum token length is 48 characters. If provided, this string is included in the new game session's ID. A game session ARN has the following format: arn:aws:gamelift:<region>::gamesession/<fleet ID>/<custom ID string or idempotency token>. Idempotency tokens remain in use for 30 days after a game session has ended; game session objects are retained for this time period and then deleted. Defaults to None.
        game_session_data(str, optional): A set of custom game session properties, formatted as a single string value. This data is passed to a game server process in the GameSession object with a request to start a new game session. Defaults to None.
        location(str, optional): A fleet's remote location to place the new game session in. If this parameter is not set, the new game session is placed in the fleet's home Region. Specify a remote location with an AWS Region code such as us-west-2. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.game.session.init.create(
                ctx, maximum_player_session_count=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.game.session.init.create maximum_player_session_count=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="create_game_session",
        op_kwargs={
            "FleetId": fleet_id,
            "AliasId": alias_id,
            "MaximumPlayerSessionCount": maximum_player_session_count,
            "Name": name,
            "GameProperties": game_properties,
            "CreatorId": creator_id,
            "GameSessionId": game_session_id,
            "IdempotencyToken": idempotency_token,
            "GameSessionData": game_session_data,
            "Location": location,
        },
    )


async def describe_all(
    hub,
    ctx,
    fleet_id: str = None,
    game_session_id: str = None,
    alias_id: str = None,
    location: str = None,
    status_filter: str = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a set of one or more game sessions in a specific fleet location. You can optionally filter the results by current game session status. Alternatively, use SearchGameSessions to request a set of active game sessions that are filtered by certain criteria. To retrieve the protection policy for game sessions, use DescribeGameSessionDetails. This operation can be used in the following ways:    To retrieve all game sessions that are currently running on all locations in a fleet, provide a fleet or alias ID, with an optional status filter. This approach returns all game sessions in the fleet's home Region and all remote locations.   To retrieve all game sessions that are currently running on a specific fleet location, provide a fleet or alias ID and a location name, with optional status filter. The location can be the fleet's home Region or any remote location.   To retrieve a specific game session, provide the game session ID. This approach looks for the game session ID in all fleets that reside in the AWS Region defined in the request.   Use the pagination parameters to retrieve results as a set of sequential pages.  If successful, a GameSession object is returned for each game session that matches the request.  Available in GameLift Local.   Learn more   Find a game session   Related actions   CreateGameSession | DescribeGameSessions | DescribeGameSessionDetails | SearchGameSessions | UpdateGameSession | GetGameSessionLogUrl | StartGameSessionPlacement | DescribeGameSessionPlacement | StopGameSessionPlacement | All APIs by task

    Args:
        fleet_id(str, optional): A unique identifier for the fleet to retrieve game sessions for. You can use either the fleet ID or ARN value. . Defaults to None.
        game_session_id(str, optional): A unique identifier for the game session to retrieve. . Defaults to None.
        alias_id(str, optional): A unique identifier for the alias associated with the fleet to retrieve game sessions for. You can use either the alias ID or ARN value. Defaults to None.
        location(str, optional): A fleet location to get game session details for. You can specify a fleet's home Region or a remote location. Use the AWS Region code format, such as us-west-2. . Defaults to None.
        status_filter(str, optional): Game session status to filter results on. You can filter on the following states: ACTIVE, TERMINATED, ACTIVATING, and TERMINATING. The last two are transitory and used for only very brief periods of time. . Defaults to None.
        limit(int, optional): The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. Defaults to None.
        next_token(str, optional): A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.game.session.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.game.session.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="describe_game_sessions",
        op_kwargs={
            "FleetId": fleet_id,
            "GameSessionId": game_session_id,
            "AliasId": alias_id,
            "Location": location,
            "StatusFilter": status_filter,
            "Limit": limit,
            "NextToken": next_token,
        },
    )


async def search(
    hub,
    ctx,
    fleet_id: str = None,
    alias_id: str = None,
    location: str = None,
    filter_expression: str = None,
    sort_expression: str = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves all active game sessions that match a set of search criteria and sorts them into a specified order.  When searching for game sessions, you specify exactly where you want to search and provide a search filter expression, a sort expression, or both. A search request can search only one fleet, but it can search all of a fleet's locations.  This operation can be used in the following ways:    To search all game sessions that are currently running on all locations in a fleet, provide a fleet or alias ID. This approach returns game sessions in the fleet's home Region and all remote locations that fit the search criteria.   To search all game sessions that are currently running on a specific fleet location, provide a fleet or alias ID and a location name. For location, you can specify a fleet's home Region or any remote location.   Use the pagination parameters to retrieve results as a set of sequential pages.  If successful, a GameSession object is returned for each game session that matches the request. Search finds game sessions that are in ACTIVE status only. To retrieve information on game sessions in other statuses, use DescribeGameSessions. You can search or sort by the following game session attributes:    gameSessionId -- A unique identifier for the game session. You can use either a GameSessionId or GameSessionArn value.     gameSessionName -- Name assigned to a game session. This value is set when requesting a new game session with CreateGameSession or updating with UpdateGameSession. Game session names do not need to be unique to a game session.    gameSessionProperties -- Custom data defined in a game session's GameProperty parameter. GameProperty values are stored as key:value pairs; the filter expression must indicate the key and a string to search the data values for. For example, to search for game sessions with custom data containing the key:value pair "gameMode:brawl", specify the following: gameSessionProperties.gameMode = "brawl". All custom data values are searched as strings.    maximumSessions -- Maximum number of player sessions allowed for a game session. This value is set when requesting a new game session with CreateGameSession or updating with UpdateGameSession.    creationTimeMillis -- Value indicating when a game session was created. It is expressed in Unix time as milliseconds.    playerSessionCount -- Number of players currently connected to a game session. This value changes rapidly as players join the session or drop out.    hasAvailablePlayerSessions -- Boolean value indicating whether a game session has reached its maximum number of players. It is highly recommended that all search requests include this filter attribute to optimize search performance and return only sessions that players can join.     Returned values for playerSessionCount and hasAvailablePlayerSessions change quickly as players join sessions and others drop out. Results should be considered a snapshot in time. Be sure to refresh search results often, and handle sessions that fill up before a player can join.    Related actions   CreateGameSession | DescribeGameSessions | DescribeGameSessionDetails | SearchGameSessions | UpdateGameSession | GetGameSessionLogUrl | StartGameSessionPlacement | DescribeGameSessionPlacement | StopGameSessionPlacement | All APIs by task

    Args:
        fleet_id(str, optional): A unique identifier for the fleet to search for active game sessions. You can use either the fleet ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both. Defaults to None.
        alias_id(str, optional): A unique identifier for the alias associated with the fleet to search for active game sessions. You can use either the alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both. Defaults to None.
        location(str, optional): A fleet location to search for game sessions. You can specify a fleet's home Region or a remote location. Use the AWS Region code format, such as us-west-2.   . Defaults to None.
        filter_expression(str, optional): String containing the search criteria for the session search. If no filter expression is included, the request returns results for all game sessions in the fleet that are in ACTIVE status. A filter expression can contain one or multiple conditions. Each condition consists of the following:    Operand -- Name of a game session attribute. Valid values are gameSessionName, gameSessionId, gameSessionProperties, maximumSessions, creationTimeMillis, playerSessionCount, hasAvailablePlayerSessions.    Comparator -- Valid comparators are: =, <>, <, >, <=, >=.     Value -- Value to be searched for. Values may be numbers, boolean values (true/false) or strings depending on the operand. String values are case sensitive and must be enclosed in single quotes. Special characters must be escaped. Boolean and string values can only be used with the comparators = and <>. For example, the following filter expression searches on gameSessionName: "FilterExpression": "gameSessionName = 'Matt\\'s Awesome Game 1'".    To chain multiple conditions in a single expression, use the logical keywords AND, OR, and NOT and parentheses as needed. For example: x AND y AND NOT z, NOT (x OR y). Session search evaluates conditions from left to right using the following precedence rules:    =, <>, <, >, <=, >=    Parentheses   NOT   AND   OR   For example, this filter expression retrieves game sessions hosting at least ten players that have an open player slot: "maximumSessions>=10 AND hasAvailablePlayerSessions=true". . Defaults to None.
        sort_expression(str, optional): Instructions on how to sort the search results. If no sort expression is included, the request returns results in random order. A sort expression consists of the following elements:    Operand -- Name of a game session attribute. Valid values are gameSessionName, gameSessionId, gameSessionProperties, maximumSessions, creationTimeMillis, playerSessionCount, hasAvailablePlayerSessions.    Order -- Valid sort orders are ASC (ascending) and DESC (descending).   For example, this sort expression returns the oldest active sessions first: "SortExpression": "creationTimeMillis ASC". Results with a null value for the sort operand are returned at the end of the list. Defaults to None.
        limit(int, optional): The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. The maximum number of results returned is 20, even if this value is not set or is set higher than 20. . Defaults to None.
        next_token(str, optional): A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.game.session.init.search(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.game.session.init.search
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="search_game_sessions",
        op_kwargs={
            "FleetId": fleet_id,
            "AliasId": alias_id,
            "Location": location,
            "FilterExpression": filter_expression,
            "SortExpression": sort_expression,
            "Limit": limit,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    game_session_id: str,
    maximum_player_session_count: int = None,
    name: str = None,
    player_session_creation_policy: str = None,
    protection_policy: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the mutable properties of a game session.  To update a game session, specify the game session ID and the values you want to change.  If successful, the updated GameSession object is returned.   Related actions   CreateGameSession | DescribeGameSessions | DescribeGameSessionDetails | SearchGameSessions | UpdateGameSession | GetGameSessionLogUrl | StartGameSessionPlacement | DescribeGameSessionPlacement | StopGameSessionPlacement | All APIs by task

    Args:
        game_session_id(str): A unique identifier for the game session to update. .
        maximum_player_session_count(int, optional): The maximum number of players that can be connected simultaneously to the game session. Defaults to None.
        name(str, optional): A descriptive label that is associated with a game session. Session names do not need to be unique. Defaults to None.
        player_session_creation_policy(str, optional): A policy that determines whether the game session is accepting new players. Defaults to None.
        protection_policy(str, optional): Game session protection policy to apply to this game session only.    NoProtection -- The game session can be terminated during a scale-down event.    FullProtection -- If the game session is in an ACTIVE status, it cannot be terminated during a scale-down event.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.game.session.init.update(ctx, game_session_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.game.session.init.update game_session_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="update_game_session",
        op_kwargs={
            "GameSessionId": game_session_id,
            "MaximumPlayerSessionCount": maximum_player_session_count,
            "Name": name,
            "PlayerSessionCreationPolicy": player_session_creation_policy,
            "ProtectionPolicy": protection_policy,
        },
    )
