"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def claim(
    hub,
    ctx,
    game_server_group_name: str,
    game_server_id: str = None,
    game_server_data: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     This operation is used with the GameLift FleetIQ solution and game server groups.  Locates an available game server and temporarily reserves it to host gameplay and players. This operation is called from a game client or client service (such as a matchmaker) to request hosting resources for a new game session. In response, GameLift FleetIQ locates an available game server, places it in CLAIMED status for 60 seconds, and returns connection information that players can use to connect to the game server.  To claim a game server, identify a game server group. You can also specify a game server ID, although this approach bypasses GameLift FleetIQ placement optimization. Optionally, include game data to pass to the game server at the start of a game session, such as a game map or player information.  When a game server is successfully claimed, connection information is returned. A claimed game server's utilization status remains AVAILABLE while the claim status is set to CLAIMED for up to 60 seconds. This time period gives the game server time to update its status to UTILIZED (using UpdateGameServer) once players join. If the game server's status is not updated within 60 seconds, the game server reverts to unclaimed status and is available to be claimed by another request. The claim time period is a fixed value and is not configurable. If you try to claim a specific game server, this request will fail in the following cases:   If the game server utilization status is UTILIZED.   If the game server claim status is CLAIMED.    When claiming a specific game server, this request will succeed even if the game server is running on an instance in DRAINING status. To avoid this, first check the instance status by calling DescribeGameServerInstances.   Learn more   GameLift FleetIQ Guide   Related actions   RegisterGameServer | ListGameServers | ClaimGameServer | DescribeGameServer | UpdateGameServer | DeregisterGameServer | All APIs by task

    Args:
        game_server_group_name(str): A unique identifier for the game server group where the game server is running. Use either the GameServerGroup name or ARN value. If you are not specifying a game server to claim, this value identifies where you want GameLift FleetIQ to look for an available game server to claim. .
        game_server_id(str, optional): A custom string that uniquely identifies the game server to claim. If this parameter is left empty, GameLift FleetIQ searches for an available game server in the specified game server group. Defaults to None.
        game_server_data(str, optional): A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using ListGameServers or ClaimGameServer. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.game.server.init.claim(
                ctx, game_server_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.game.server.init.claim game_server_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="claim_game_server",
        op_kwargs={
            "GameServerGroupName": game_server_group_name,
            "GameServerId": game_server_id,
            "GameServerData": game_server_data,
        },
    )


async def deregister(
    hub, ctx, game_server_group_name: str, game_server_id: str
) -> None:
    r"""
    **Autogenerated function**

     This operation is used with the GameLift FleetIQ solution and game server groups.  Removes the game server from a game server group. As a result of this operation, the deregistered game server can no longer be claimed and will not be returned in a list of active game servers.  To deregister a game server, specify the game server group and game server ID. If successful, this operation emits a CloudWatch event with termination timestamp and reason.  Learn more   GameLift FleetIQ Guide   Related actions   RegisterGameServer | ListGameServers | ClaimGameServer | DescribeGameServer | UpdateGameServer | DeregisterGameServer | All APIs by task

    Args:
        game_server_group_name(str): A unique identifier for the game server group where the game server is running. Use either the GameServerGroup name or ARN value.
        game_server_id(str): A custom string that uniquely identifies the game server to deregister.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.game.server.init.deregister(
                ctx, game_server_group_name=value, game_server_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.game.server.init.deregister game_server_group_name=value, game_server_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="deregister_game_server",
        op_kwargs={
            "GameServerGroupName": game_server_group_name,
            "GameServerId": game_server_id,
        },
    )


async def describe(hub, ctx, game_server_group_name: str, game_server_id: str) -> Dict:
    r"""
    **Autogenerated function**

     This operation is used with the GameLift FleetIQ solution and game server groups.  Retrieves information for a registered game server. Information includes game server status, health check info, and the instance that the game server is running on.  To retrieve game server information, specify the game server ID. If successful, the requested game server object is returned.   Learn more   GameLift FleetIQ Guide   Related actions   RegisterGameServer | ListGameServers | ClaimGameServer | DescribeGameServer | UpdateGameServer | DeregisterGameServer | All APIs by task

    Args:
        game_server_group_name(str): A unique identifier for the game server group where the game server is running. Use either the GameServerGroup name or ARN value.
        game_server_id(str): A custom string that uniquely identifies the game server information to be retrieved.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.game.server.init.describe(
                ctx, game_server_group_name=value, game_server_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.game.server.init.describe game_server_group_name=value, game_server_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="describe_game_server",
        op_kwargs={
            "GameServerGroupName": game_server_group_name,
            "GameServerId": game_server_id,
        },
    )


async def list_all(
    hub,
    ctx,
    game_server_group_name: str,
    sort_order: str = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     This operation is used with the GameLift FleetIQ solution and game server groups.  Retrieves information on all game servers that are currently active in a specified game server group. You can opt to sort the list by game server age. Use the pagination parameters to retrieve results in a set of sequential segments.   Learn more   GameLift FleetIQ Guide   Related actions   RegisterGameServer | ListGameServers | ClaimGameServer | DescribeGameServer | UpdateGameServer | DeregisterGameServer | All APIs by task

    Args:
        game_server_group_name(str): An identifier for the game server group to retrieve a list of game servers from. Use either the GameServerGroup name or ARN value.
        sort_order(str, optional): Indicates how to sort the returned data based on game server registration timestamp. Use ASCENDING to retrieve oldest game servers first, or use DESCENDING to retrieve newest game servers first. If this parameter is left empty, game servers are returned in no particular order. Defaults to None.
        limit(int, optional): The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. Defaults to None.
        next_token(str, optional): A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.game.server.init.list_all(
                ctx, game_server_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.game.server.init.list_all game_server_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="list_game_servers",
        op_kwargs={
            "GameServerGroupName": game_server_group_name,
            "SortOrder": sort_order,
            "Limit": limit,
            "NextToken": next_token,
        },
    )


async def register(
    hub,
    ctx,
    game_server_group_name: str,
    game_server_id: str,
    instance_id: str,
    connection_info: str = None,
    game_server_data: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     This operation is used with the GameLift FleetIQ solution and game server groups.  Creates a new game server resource and notifies GameLift FleetIQ that the game server is ready to host gameplay and players. This operation is called by a game server process that is running on an instance in a game server group. Registering game servers enables GameLift FleetIQ to track available game servers and enables game clients and services to claim a game server for a new game session.  To register a game server, identify the game server group and instance where the game server is running, and provide a unique identifier for the game server. You can also include connection and game server data. When a game client or service requests a game server by calling ClaimGameServer, this information is returned in the response. Once a game server is successfully registered, it is put in status AVAILABLE. A request to register a game server may fail if the instance it is running on is in the process of shutting down as part of instance balancing or scale-down activity.   Learn more   GameLift FleetIQ Guide   Related actions   RegisterGameServer | ListGameServers | ClaimGameServer | DescribeGameServer | UpdateGameServer | DeregisterGameServer | All APIs by task

    Args:
        game_server_group_name(str): A unique identifier for the game server group where the game server is running. Use either the GameServerGroup name or ARN value.
        game_server_id(str): A custom string that uniquely identifies the game server to register. Game server IDs are developer-defined and must be unique across all game server groups in your AWS account.
        instance_id(str): The unique identifier for the instance where the game server is running. This ID is available in the instance metadata. EC2 instance IDs use a 17-character format, for example: i-1234567890abcdef0.
        connection_info(str, optional): Information that is needed to make inbound client connections to the game server. This might include the IP address and port, DNS name, and other information. Defaults to None.
        game_server_data(str, optional): A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using ListGameServers or ClaimGameServer. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.game.server.init.register(
                ctx, game_server_group_name=value, game_server_id=value, instance_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.game.server.init.register game_server_group_name=value, game_server_id=value, instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="register_game_server",
        op_kwargs={
            "GameServerGroupName": game_server_group_name,
            "GameServerId": game_server_id,
            "InstanceId": instance_id,
            "ConnectionInfo": connection_info,
            "GameServerData": game_server_data,
        },
    )


async def update(
    hub,
    ctx,
    game_server_group_name: str,
    game_server_id: str,
    game_server_data: str = None,
    utilization_status: str = None,
    health_check: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     This operation is used with the GameLift FleetIQ solution and game server groups.  Updates information about a registered game server to help GameLift FleetIQ to track game server availability. This operation is called by a game server process that is running on an instance in a game server group.  Use this operation to update the following types of game server information. You can make all three types of updates in the same request:   To update the game server's utilization status, identify the game server and game server group and specify the current utilization status. Use this status to identify when game servers are currently hosting games and when they are available to be claimed.   To report health status, identify the game server and game server group and set health check to HEALTHY. If a game server does not report health status for a certain length of time, the game server is no longer considered healthy. As a result, it will be eventually deregistered from the game server group to avoid affecting utilization metrics. The best practice is to report health every 60 seconds.   To change game server metadata, provide updated game server data.   Once a game server is successfully updated, the relevant statuses and timestamps are updated.  Learn more   GameLift FleetIQ Guide   Related actions   RegisterGameServer | ListGameServers | ClaimGameServer | DescribeGameServer | UpdateGameServer | DeregisterGameServer | All APIs by task

    Args:
        game_server_group_name(str): A unique identifier for the game server group where the game server is running. Use either the GameServerGroup name or ARN value.
        game_server_id(str): A custom string that uniquely identifies the game server to update.
        game_server_data(str, optional): A set of custom game server properties, formatted as a single string value. This data is passed to a game client or service when it requests information on game servers using ListGameServers or ClaimGameServer. . Defaults to None.
        utilization_status(str, optional): Indicates whether the game server is available or is currently hosting gameplay. Defaults to None.
        health_check(str, optional): Indicates health status of the game server. A request that includes this parameter updates the game server's LastHealthCheckTime timestamp. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.game.server.init.update(
                ctx, game_server_group_name=value, game_server_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.game.server.init.update game_server_group_name=value, game_server_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="update_game_server",
        op_kwargs={
            "GameServerGroupName": game_server_group_name,
            "GameServerId": game_server_id,
            "GameServerData": game_server_data,
            "UtilizationStatus": utilization_status,
            "HealthCheck": health_check,
        },
    )
