"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, fleet_id: str, location: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a fleet's inbound connection permissions. Connection permissions specify the range of IP addresses and port settings that incoming traffic can use to access server processes in the fleet. Game sessions that are running on instances in the fleet must use connections that fall in this range. This operation can be used in the following ways:    To retrieve the inbound connection permissions for a fleet, identify the fleet's unique identifier.    To check the status of recent updates to a fleet remote location, specify the fleet ID and a location. Port setting updates can take time to propagate across all locations.    If successful, a set of IpPermission objects is returned for the requested fleet ID. When a location is specified, a pending status is included. If the requested fleet has been deleted, the result set is empty.  Learn more   Setting up GameLift fleets   Related actions   ListFleets | DescribeEC2InstanceLimits | DescribeFleetAttributes | DescribeFleetCapacity | DescribeFleetEvents | DescribeFleetLocationAttributes | DescribeFleetPortSettings | DescribeFleetUtilization | DescribeRuntimeConfiguration | DescribeScalingPolicies | All APIs by task

    Args:
        fleet_id(str): A unique identifier for the fleet to retrieve port settings for. You can use either the fleet ID or ARN value.
        location(str, optional): A remote location to check for status of port setting updates. Use the AWS Region code format, such as us-west-2. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.fleet.port_setting.describe_all(ctx, fleet_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.fleet.port_setting.describe_all fleet_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="describe_fleet_port_settings",
        op_kwargs={"FleetId": fleet_id, "Location": location},
    )


async def update_multiple(
    hub,
    ctx,
    fleet_id: str,
    inbound_permission_authorizations: List = None,
    inbound_permission_revocations: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates permissions that allow inbound traffic to connect to game sessions that are being hosted on instances in the fleet.  To update settings, specify the fleet ID to be updated and specify the changes to be made. List the permissions you want to add in InboundPermissionAuthorizations, and permissions you want to remove in InboundPermissionRevocations. Permissions to be removed must match existing fleet permissions.  If successful, the fleet ID for the updated fleet is returned. For fleets with remote locations, port setting updates can take time to propagate across all locations. You can check the status of updates in each location by calling DescribeFleetPortSettings with a location name.  Learn more   Setting up GameLift fleets   Related actions   CreateFleetLocations | UpdateFleetAttributes | UpdateFleetCapacity | UpdateFleetPortSettings | UpdateRuntimeConfiguration | StopFleetActions | StartFleetActions | PutScalingPolicy | DeleteFleet | DeleteFleetLocations | DeleteScalingPolicy | All APIs by task

    Args:
        fleet_id(str): A unique identifier for the fleet to update port settings for. You can use either the fleet ID or ARN value.
        inbound_permission_authorizations(List, optional): A collection of port settings to be added to the fleet resource. Defaults to None.
        inbound_permission_revocations(List, optional): A collection of port settings to be removed from the fleet resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.fleet.port_setting.update_multiple(ctx, fleet_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.fleet.port_setting.update_multiple fleet_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="update_fleet_port_settings",
        op_kwargs={
            "FleetId": fleet_id,
            "InboundPermissionAuthorizations": inbound_permission_authorizations,
            "InboundPermissionRevocations": inbound_permission_revocations,
        },
    )
