"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create_multiple(hub, ctx, fleet_id: str, locations: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds remote locations to a fleet and begins populating the new locations with EC2 instances. The new instances conform to the fleet's instance type, auto-scaling, and other configuration settings.   This operation cannot be used with fleets that don't support remote locations. Fleets can have multiple locations only if they reside in AWS Regions that support this feature (see CreateFleet for the complete list) and were created after the feature was released in March 2021.  To add fleet locations, specify the fleet to be updated and provide a list of one or more locations.  If successful, this operation returns the list of added locations with their status set to NEW. GameLift initiates the process of starting an instance in each added location. You can track the status of each new location by monitoring location creation events using DescribeFleetEvents. Alternatively, you can poll location status by calling DescribeFleetLocationAttributes. After a location status becomes ACTIVE, you can adjust the location's capacity as needed with UpdateFleetCapacity.  Learn more   Setting up fleets   Multi-location fleets   Related actions   CreateFleetLocations | DescribeFleetLocationAttributes | DescribeFleetLocationCapacity | DescribeFleetLocationUtilization | DescribeFleetAttributes | DescribeFleetCapacity | DescribeFleetUtilization | UpdateFleetCapacity | StopFleetActions | DeleteFleetLocations | All APIs by task

    Args:
        fleet_id(str): A unique identifier for the fleet to add locations to. You can use either the fleet ID or ARN value.
        locations(List): A list of locations to deploy additional instances to and manage as part of the fleet. You can add any GameLift-supported AWS Region as a remote location, in the form of an AWS Region code such as us-west-2. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.fleet.location.init.create_multiple(
                ctx, fleet_id=value, locations=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.fleet.location.init.create_multiple fleet_id=value, locations=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="create_fleet_locations",
        op_kwargs={"FleetId": fleet_id, "Locations": locations},
    )


async def delete_multiple(hub, ctx, fleet_id: str, locations: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes locations from a multi-location fleet. When deleting a location, all game server process and all instances that are still active in the location are shut down.  To delete fleet locations, identify the fleet ID and provide a list of the locations to be deleted.  If successful, GameLift sets the location status to DELETING, and begins to shut down existing server processes and terminate instances in each location being deleted. When completed, the location status changes to TERMINATED.  Learn more   Setting up GameLift fleets   Related actions   CreateFleetLocations | DescribeFleetLocationAttributes | DescribeFleetLocationCapacity | DescribeFleetLocationUtilization | DescribeFleetAttributes | DescribeFleetCapacity | DescribeFleetUtilization | UpdateFleetCapacity | StopFleetActions | DeleteFleetLocations | All APIs by task

    Args:
        fleet_id(str): A unique identifier for the fleet to delete locations for. You can use either the fleet ID or ARN value.
        locations(List): The list of fleet locations to delete. Specify locations in the form of an AWS Region code, such as us-west-2.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.fleet.location.init.delete_multiple(
                ctx, fleet_id=value, locations=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.fleet.location.init.delete_multiple fleet_id=value, locations=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="delete_fleet_locations",
        op_kwargs={"FleetId": fleet_id, "Locations": locations},
    )
