"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, fleet_id: str, location: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the resource capacity settings for a fleet location. The data returned includes the current capacity (number of EC2 instances) and some scaling settings for the requested fleet location. Use this operation to retrieve capacity information for a fleet's remote location or home Region (you can also retrieve home Region capacity by calling DescribeFleetCapacity). To retrieve capacity data, identify a fleet and location.  If successful, a FleetCapacity object is returned for the requested fleet location.   Learn more   Setting up GameLift fleets   GameLift metrics for fleets   Related actions   CreateFleetLocations | DescribeFleetLocationAttributes | DescribeFleetLocationCapacity | DescribeFleetLocationUtilization | DescribeFleetAttributes | DescribeFleetCapacity | DescribeFleetUtilization | UpdateFleetCapacity | StopFleetActions | DeleteFleetLocations | All APIs by task

    Args:
        fleet_id(str): A unique identifier for the fleet to request location capacity for. You can use either the fleet ID or ARN value.
        location(str): The fleet location to retrieve capacity information for. Specify a location in the form of an AWS Region code, such as us-west-2.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.fleet.location.capacity.describe(
                ctx, fleet_id=value, location=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.fleet.location.capacity.describe fleet_id=value, location=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="describe_fleet_location_capacity",
        op_kwargs={"FleetId": fleet_id, "Location": location},
    )
