"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub, ctx, fleet_ids: List = None, limit: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves core fleet-wide properties, including the computing hardware and deployment configuration for all instances in the fleet. This operation can be used in the following ways:    To get attributes for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.    To get attributes for all fleets, do not provide a fleet identifier.    When requesting attributes for multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.  If successful, a FleetAttributes object is returned for each fleet requested, unless the fleet identifier is not found.   Some API operations limit the number of fleet IDs that allowed in one request. If a request exceeds this limit, the request fails and the error message contains the maximum allowed number.   Learn more   Setting up GameLift fleets   Related actions   ListFleets | DescribeEC2InstanceLimits | DescribeFleetAttributes | DescribeFleetCapacity | DescribeFleetEvents | DescribeFleetLocationAttributes | DescribeFleetPortSettings | DescribeFleetUtilization | DescribeRuntimeConfiguration | DescribeScalingPolicies | All APIs by task

    Args:
        fleet_ids(List, optional): A list of unique fleet identifiers to retrieve attributes for. You can use either the fleet ID or ARN value. To retrieve attributes for all current fleets, do not include this parameter. . Defaults to None.
        limit(int, optional): The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. This parameter is ignored when the request specifies one or a list of fleet IDs. Defaults to None.
        next_token(str, optional): A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. This parameter is ignored when the request specifies one or a list of fleet IDs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.fleet.attribute.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.fleet.attribute.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="describe_fleet_attributes",
        op_kwargs={"FleetIds": fleet_ids, "Limit": limit, "NextToken": next_token},
    )


async def update_multiple(
    hub,
    ctx,
    fleet_id: str,
    name: str = None,
    description: str = None,
    new_game_session_protection_policy: str = None,
    resource_creation_limit_policy: Dict = None,
    metric_groups: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a fleet's mutable attributes, including game session protection and resource creation limits. To update fleet attributes, specify the fleet ID and the property values that you want to change.  If successful, an updated FleetAttributes object is returned.  Learn more   Setting up GameLift fleets   Related actions   CreateFleetLocations | UpdateFleetAttributes | UpdateFleetCapacity | UpdateFleetPortSettings | UpdateRuntimeConfiguration | StopFleetActions | StartFleetActions | PutScalingPolicy | DeleteFleet | DeleteFleetLocations | DeleteScalingPolicy | All APIs by task

    Args:
        fleet_id(str): A unique identifier for the fleet to update attribute metadata for. You can use either the fleet ID or ARN value.
        name(str, optional): A descriptive label that is associated with a fleet. Fleet names do not need to be unique. Defaults to None.
        description(str, optional): A human-readable description of a fleet. Defaults to None.
        new_game_session_protection_policy(str, optional): The game session protection policy to apply to all new instances created in this fleet. Instances that already exist are not affected. You can set protection for individual instances using UpdateGameSession.    NoProtection -- The game session can be terminated during a scale-down event.    FullProtection -- If the game session is in an ACTIVE status, it cannot be terminated during a scale-down event.  . Defaults to None.
        resource_creation_limit_policy(Dict, optional): Policy settings that limit the number of game sessions an individual player can create over a span of time. . Defaults to None.
        metric_groups(List, optional): The name of a metric group to add this fleet to. Use a metric group in Amazon CloudWatch to aggregate the metrics from multiple fleets. Provide an existing metric group name, or create a new metric group by providing a new name. A fleet can only be in one metric group at a time. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.fleet.attribute.update_multiple(ctx, fleet_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.fleet.attribute.update_multiple fleet_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="update_fleet_attributes",
        op_kwargs={
            "FleetId": fleet_id,
            "Name": name,
            "Description": description,
            "NewGameSessionProtectionPolicy": new_game_session_protection_policy,
            "ResourceCreationLimitPolicy": resource_creation_limit_policy,
            "MetricGroups": metric_groups,
        },
    )
