"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def start(hub, ctx, fleet_id: str, actions: List, location: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Resumes certain types of activity on fleet instances that were suspended with StopFleetActions. For multi-location fleets, fleet actions are managed separately for each location. Currently, this operation is used to restart a fleet's auto-scaling activity. This operation can be used in the following ways:    To restart actions on instances in the fleet's home Region, provide a fleet ID and the type of actions to resume.    To restart actions on instances in one of the fleet's remote locations, provide a fleet ID, a location name, and the type of actions to resume.    If successful, GameLift once again initiates scaling events as triggered by the fleet's scaling policies. If actions on the fleet location were never stopped, this operation will have no effect. You can view a fleet's stopped actions using DescribeFleetAttributes or DescribeFleetLocationAttributes.  Learn more   Setting up GameLift fleets   Related actions   CreateFleet | UpdateFleetCapacity | PutScalingPolicy | DescribeEC2InstanceLimits | DescribeFleetAttributes | DescribeFleetLocationAttributes | UpdateFleetAttributes | StopFleetActions | DeleteFleet | All APIs by task

    Args:
        fleet_id(str): A unique identifier for the fleet to restart actions on. You can use either the fleet ID or ARN value.
        actions(List): List of actions to restart on the fleet.
        location(str, optional): The fleet location to restart fleet actions for. Specify a location in the form of an AWS Region code, such as us-west-2. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.fleet.action.start(ctx, fleet_id=value, actions=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.fleet.action.start fleet_id=value, actions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="start_fleet_actions",
        op_kwargs={"FleetId": fleet_id, "Actions": actions, "Location": location},
    )


async def stop(hub, ctx, fleet_id: str, actions: List, location: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Suspends certain types of activity in a fleet location. Currently, this operation is used to stop auto-scaling activity. For multi-location fleets, fleet actions are managed separately for each location.  Stopping fleet actions has several potential purposes. It allows you to temporarily stop auto-scaling activity but retain your scaling policies for use in the future. For multi-location fleets, you can set up fleet-wide auto-scaling, and then opt out of it for certain locations.  This operation can be used in the following ways:    To stop actions on instances in the fleet's home Region, provide a fleet ID and the type of actions to suspend.    To stop actions on instances in one of the fleet's remote locations, provide a fleet ID, a location name, and the type of actions to suspend.    If successful, GameLift no longer initiates scaling events except in response to manual changes using UpdateFleetCapacity. You can view a fleet's stopped actions using DescribeFleetAttributes or DescribeFleetLocationAttributes. Suspended activity can be restarted using StartFleetActions.  Learn more   Setting up GameLift Fleets   Related actions   CreateFleet | UpdateFleetCapacity | PutScalingPolicy | DescribeEC2InstanceLimits | DescribeFleetAttributes | DescribeFleetLocationAttributes | UpdateFleetAttributes | StopFleetActions | DeleteFleet | All APIs by task

    Args:
        fleet_id(str): A unique identifier for the fleet to stop actions on. You can use either the fleet ID or ARN value.
        actions(List): List of actions to suspend on the fleet. .
        location(str, optional): The fleet location to stop fleet actions for. Specify a location in the form of an AWS Region code, such as us-west-2. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.fleet.action.stop(ctx, fleet_id=value, actions=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.fleet.action.stop fleet_id=value, actions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="stop_fleet_actions",
        op_kwargs={"FleetId": fleet_id, "Actions": actions, "Location": location},
    )
