"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str = None,
    version: str = None,
    storage_location: Dict = None,
    operating_system: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Amazon GameLift build resource for your game server binary files. Game server binaries must be combined into a zip file for use with Amazon GameLift.   When setting up a new game build for GameLift, we recommend using the AWS CLI command  upload-build . This helper command combines two tasks: (1) it uploads your build files from a file directory to a GameLift Amazon S3 location, and (2) it creates a new build resource.   The CreateBuild operation can used in the following scenarios:   To create a new game build with build files that are in an Amazon S3 location under an AWS account that you control. To use this option, you must first give Amazon GameLift access to the Amazon S3 bucket. With permissions in place, call CreateBuild and specify a build name, operating system, and the Amazon S3 storage location of your game build.   To directly upload your build files to a GameLift Amazon S3 location. To use this option, first call CreateBuild and specify a build name and operating system. This operation creates a new build resource and also returns an Amazon S3 location with temporary access credentials. Use the credentials to manually upload your build files to the specified Amazon S3 location. For more information, see Uploading Objects in the Amazon S3 Developer Guide. Build files can be uploaded to the GameLift Amazon S3 location once only; that can't be updated.    If successful, this operation creates a new build resource with a unique build ID and places it in INITIALIZED status. A build must be in READY status before you can create fleets with it.  Learn more   Uploading Your Game    Create a Build with Files in Amazon S3   Related actions   CreateBuild | ListBuilds | DescribeBuild | UpdateBuild | DeleteBuild | All APIs by task

    Args:
        name(str, optional): A descriptive label that is associated with a build. Build names do not need to be unique. You can use UpdateBuild to change this value later. . Defaults to None.
        version(str, optional): Version information that is associated with a build or script. Version strings do not need to be unique. You can use UpdateBuild to change this value later. . Defaults to None.
        storage_location(Dict, optional): Information indicating where your game build files are stored. Use this parameter only when creating a build with files stored in an Amazon S3 bucket that you own. The storage location must specify an Amazon S3 bucket name and key. The location must also specify a role ARN that you set up to allow Amazon GameLift to access your Amazon S3 bucket. The S3 bucket and your new build must be in the same Region. Defaults to None.
        operating_system(str, optional): The operating system that the game server binaries are built to run on. This value determines the type of fleet resources that you can use for this build. If your game build contains multiple executables, they all must run on the same operating system. If an operating system is not specified when creating a build, Amazon GameLift uses the default value (WINDOWS_2012). This value cannot be changed later. Defaults to None.
        tags(List, optional): A list of labels to assign to the new build resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see  Tagging AWS Resources in the AWS General Reference. Once the resource is created, you can use TagResource, UntagResource, and ListTagsForResource to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.build.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.build.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="create_build",
        op_kwargs={
            "Name": name,
            "Version": version,
            "StorageLocation": storage_location,
            "OperatingSystem": operating_system,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, build_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a build. This operation permanently deletes the build resource and any uploaded build files. Deleting a build does not affect the status of any active fleets using the build, but you can no longer create new fleets with the deleted build. To delete a build, specify the build ID.   Learn more    Upload a Custom Server Build   Related actions   CreateBuild | ListBuilds | DescribeBuild | UpdateBuild | DeleteBuild | All APIs by task

    Args:
        build_id(str): A unique identifier for the build to delete. You can use either the build ID or ARN value. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.build.delete(ctx, build_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.build.delete build_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="delete_build",
        op_kwargs={"BuildId": build_id},
    )


async def describe(hub, ctx, build_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves properties for a custom game build. To request a build resource, specify a build ID. If successful, an object containing the build properties is returned.  Learn more    Upload a Custom Server Build   Related actions   CreateBuild | ListBuilds | DescribeBuild | UpdateBuild | DeleteBuild | All APIs by task

    Args:
        build_id(str): A unique identifier for the build to retrieve properties for. You can use either the build ID or ARN value. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.build.describe(ctx, build_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.build.describe build_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="describe_build",
        op_kwargs={"BuildId": build_id},
    )


async def list_all(
    hub, ctx, status: str = None, limit: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves build resources for all builds associated with the AWS account in use. You can limit results to builds that are in a specific status by using the Status parameter. Use the pagination parameters to retrieve results in a set of sequential pages.   Build resources are not listed in any particular order.   Learn more    Upload a Custom Server Build   Related actions   CreateBuild | ListBuilds | DescribeBuild | UpdateBuild | DeleteBuild | All APIs by task

    Args:
        status(str, optional): Build status to filter results by. To retrieve all builds, leave this parameter empty. Possible build statuses include the following:    INITIALIZED -- A new build has been defined, but no files have been uploaded. You cannot create fleets for builds that are in this status. When a build is successfully created, the build status is set to this value.     READY -- The game build has been successfully uploaded. You can now create new fleets for this build.    FAILED -- The game build upload failed. You cannot create new fleets for this build.   . Defaults to None.
        limit(int, optional): The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. Defaults to None.
        next_token(str, optional): A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.build.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.build.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="list_builds",
        op_kwargs={"Status": status, "Limit": limit, "NextToken": next_token},
    )


async def update(
    hub, ctx, build_id: str, name: str = None, version: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates metadata in a build resource, including the build name and version. To update the metadata, specify the build ID to update and provide the new values. If successful, a build object containing the updated metadata is returned.  Learn more    Upload a Custom Server Build   Related actions   CreateBuild | ListBuilds | DescribeBuild | UpdateBuild | DeleteBuild | All APIs by task

    Args:
        build_id(str): A unique identifier for the build to update. You can use either the build ID or ARN value. .
        name(str, optional): A descriptive label that is associated with a build. Build names do not need to be unique. . Defaults to None.
        version(str, optional): Version information that is associated with a build or script. Version strings do not need to be unique. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.build.update(ctx, build_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.build.update build_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="update_build",
        op_kwargs={"BuildId": build_id, "Name": name, "Version": version},
    )
