"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    routing_strategy: Dict,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an alias for a fleet. In most situations, you can use an alias ID in place of a fleet ID. An alias provides a level of abstraction for a fleet that is useful when redirecting player traffic from one fleet to another, such as when updating your game build.  Amazon GameLift supports two types of routing strategies for aliases: simple and terminal. A simple alias points to an active fleet. A terminal alias is used to display messaging or link to a URL instead of routing players to an active fleet. For example, you might use a terminal alias when a game version is no longer supported and you want to direct players to an upgrade site.  To create a fleet alias, specify an alias name, routing strategy, and optional description. Each simple alias can point to only one fleet, but a fleet can have multiple aliases. If successful, a new alias record is returned, including an alias ID and an ARN. You can reassign an alias to another fleet by calling UpdateAlias.  Related actions   CreateAlias | ListAliases | DescribeAlias | UpdateAlias | DeleteAlias | ResolveAlias | All APIs by task

    Args:
        name(str): A descriptive label that is associated with an alias. Alias names do not need to be unique.
        description(str, optional): A human-readable description of the alias. Defaults to None.
        routing_strategy(Dict): The routing configuration, including routing type and fleet target, for the alias. .
        tags(List, optional): A list of labels to assign to the new alias resource. Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see  Tagging AWS Resources in the AWS General Reference. Once the resource is created, you can use TagResource, UntagResource, and ListTagsForResource to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.alias.create(ctx, name=value, routing_strategy=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.alias.create name=value, routing_strategy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="create_alias",
        op_kwargs={
            "Name": name,
            "Description": description,
            "RoutingStrategy": routing_strategy,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, alias_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an alias. This operation removes all record of the alias. Game clients attempting to access a server process using the deleted alias receive an error. To delete an alias, specify the alias ID to be deleted.  Related actions   CreateAlias | ListAliases | DescribeAlias | UpdateAlias | DeleteAlias | ResolveAlias | All APIs by task

    Args:
        alias_id(str): A unique identifier of the alias that you want to delete. You can use either the alias ID or ARN value.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.alias.delete(ctx, alias_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.alias.delete alias_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="delete_alias",
        op_kwargs={"AliasId": alias_id},
    )


async def describe(hub, ctx, alias_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves properties for an alias. This operation returns all alias metadata and settings. To get an alias's target fleet ID only, use ResolveAlias.  To get alias properties, specify the alias ID. If successful, the requested alias record is returned.  Related actions   CreateAlias | ListAliases | DescribeAlias | UpdateAlias | DeleteAlias | ResolveAlias | All APIs by task

    Args:
        alias_id(str): The unique identifier for the fleet alias that you want to retrieve. You can use either the alias ID or ARN value. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.alias.describe(ctx, alias_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.alias.describe alias_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="describe_alias",
        op_kwargs={"AliasId": alias_id},
    )


async def list_all(
    hub,
    ctx,
    routing_strategy_type: str = None,
    name: str = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves all aliases for this AWS account. You can filter the result set by alias name and/or routing strategy type. Use the pagination parameters to retrieve results in sequential pages.  Returned aliases are not listed in any particular order.   Related actions   CreateAlias | ListAliases | DescribeAlias | UpdateAlias | DeleteAlias | ResolveAlias | All APIs by task

    Args:
        routing_strategy_type(str, optional): The routing type to filter results on. Use this parameter to retrieve only aliases with a certain routing type. To retrieve all aliases, leave this parameter empty. Possible routing types include the following:    SIMPLE -- The alias resolves to one specific fleet. Use this type when routing to active fleets.    TERMINAL -- The alias does not resolve to a fleet but instead can be used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException with the RoutingStrategy message embedded.  . Defaults to None.
        name(str, optional): A descriptive label that is associated with an alias. Alias names do not need to be unique. Defaults to None.
        limit(int, optional): The maximum number of results to return. Use this parameter with NextToken to get results as a set of sequential pages. Defaults to None.
        next_token(str, optional): A token that indicates the start of the next sequential page of results. Use the token that is returned with a previous call to this operation. To start at the beginning of the result set, do not specify a value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.alias.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.alias.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="list_aliases",
        op_kwargs={
            "RoutingStrategyType": routing_strategy_type,
            "Name": name,
            "Limit": limit,
            "NextToken": next_token,
        },
    )


async def resolve(hub, ctx, alias_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the fleet ID that an alias is currently pointing to.  Related actions   CreateAlias | ListAliases | DescribeAlias | UpdateAlias | DeleteAlias | ResolveAlias | All APIs by task

    Args:
        alias_id(str): The unique identifier of the alias that you want to retrieve a fleet ID for. You can use either the alias ID or ARN value.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.alias.resolve(ctx, alias_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.alias.resolve alias_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="resolve_alias",
        op_kwargs={"AliasId": alias_id},
    )


async def update(
    hub,
    ctx,
    alias_id: str,
    name: str = None,
    description: str = None,
    routing_strategy: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates properties for an alias. To update properties, specify the alias ID to be updated and provide the information to be changed. To reassign an alias to another fleet, provide an updated routing strategy. If successful, the updated alias record is returned.  Related actions   CreateAlias | ListAliases | DescribeAlias | UpdateAlias | DeleteAlias | ResolveAlias | All APIs by task

    Args:
        alias_id(str): A unique identifier for the alias that you want to update. You can use either the alias ID or ARN value.
        name(str, optional): A descriptive label that is associated with an alias. Alias names do not need to be unique. Defaults to None.
        description(str, optional): A human-readable description of the alias. Defaults to None.
        routing_strategy(Dict, optional): The routing configuration, including routing type and fleet target, for the alias. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.gamelift.alias.update(ctx, alias_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.gamelift.alias.update alias_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="gamelift",
        operation="update_alias",
        op_kwargs={
            "AliasId": alias_id,
            "Name": name,
            "Description": description,
            "RoutingStrategy": routing_strategy,
        },
    )
