"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    file_system_type: str,
    storage_capacity: int,
    subnet_ids: List,
    client_request_token: str = None,
    storage_type: str = None,
    security_group_ids: List = None,
    tags: List = None,
    kms_key_id: str = None,
    windows_configuration: Dict = None,
    lustre_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new, empty Amazon FSx file system. If a file system with the specified client request token exists and the parameters match, CreateFileSystem returns the description of the existing file system. If a file system specified client request token exists and the parameters don't match, this call returns IncompatibleParameterError. If a file system with the specified client request token doesn't exist, CreateFileSystem does the following:    Creates a new, empty Amazon FSx file system with an assigned ID, and an initial lifecycle state of CREATING.   Returns the description of the file system.   This operation requires a client request token in the request that Amazon FSx uses to ensure idempotent creation. This means that calling the operation multiple times with the same client request token has no effect. By using the idempotent operation, you can retry a CreateFileSystem operation without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives success as long as the parameters are the same.  The CreateFileSystem call returns while the file system's lifecycle state is still CREATING. You can check the file-system creation status by calling the DescribeFileSystems operation, which returns the file system state along with other information.

    Args:
        client_request_token(str, optional): A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK. Defaults to None.
        file_system_type(str): The type of Amazon FSx file system to create, either WINDOWS or LUSTRE.
        storage_capacity(int): Sets the storage capacity of the file system that you're creating. For Lustre file systems:   For SCRATCH_2 and PERSISTENT_1 SSD deployment types, valid values are 1200 GiB, 2400 GiB, and increments of 2400 GiB.   For PERSISTENT HDD file systems, valid values are increments of 6000 GiB for 12 MB/s/TiB file systems and increments of 1800 GiB for 40 MB/s/TiB file systems.   For SCRATCH_1 deployment type, valid values are 1200 GiB, 2400 GiB, and increments of 3600 GiB.   For Windows file systems:   If StorageType=SSD, valid values are 32 GiB - 65,536 GiB (64 TiB).   If StorageType=HDD, valid values are 2000 GiB - 65,536 GiB (64 TiB).  .
        storage_type(str, optional): Sets the storage type for the file system you're creating. Valid values are SSD and HDD.   Set to SSD to use solid state drive storage. SSD is supported on all Windows and Lustre deployment types.   Set to HDD to use hard disk drive storage. HDD is supported on SINGLE_AZ_2 and MULTI_AZ_1 Windows file system deployment types, and on PERSISTENT Lustre file system deployment types.     Default value is SSD. For more information, see  Storage Type Options in the Amazon FSx for Windows User Guide and Multiple Storage Options in the Amazon FSx for Lustre User Guide. . Defaults to None.
        subnet_ids(List): Specifies the IDs of the subnets that the file system will be accessible from. For Windows MULTI_AZ_1 file system deployment types, provide exactly two subnet IDs, one for the preferred file server and one for the standby file server. You specify one of these subnets as the preferred subnet using the WindowsConfiguration > PreferredSubnetID property. For more information, see  Availability and durability: Single-AZ and Multi-AZ file systems. For Windows SINGLE_AZ_1 and SINGLE_AZ_2 file system deployment types and Lustre file systems, provide exactly one subnet ID. The file server is launched in that subnet's Availability Zone.
        security_group_ids(List, optional): A list of IDs specifying the security groups to apply to all network interfaces created for file system access. This list isn't returned in later requests to describe the file system. Defaults to None.
        tags(List, optional): The tags to apply to the file system being created. The key value of the Name tag appears in the console as the file system name. Defaults to None.
        kms_key_id(str, optional): The ID of the AWS Key Management Service (AWS KMS) key used to encrypt the file system's data for Amazon FSx for Windows File Server file systems and Amazon FSx for Lustre PERSISTENT_1 file systems at rest. In either case, if not specified, the Amazon FSx managed key is used. The Amazon FSx for Lustre SCRATCH_1 and SCRATCH_2 file systems are always encrypted at rest using Amazon FSx managed keys. For more information, see Encrypt in the AWS Key Management Service API Reference. Defaults to None.
        windows_configuration(Dict, optional): The Microsoft Windows configuration for the file system being created. . Defaults to None.
        lustre_configuration(Dict, optional): The Lustre configuration for the file system being created. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fsx.file_system.init.create(
                ctx, file_system_type=value, storage_capacity=value, subnet_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fsx.file_system.init.create file_system_type=value, storage_capacity=value, subnet_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fsx",
        operation="create_file_system",
        op_kwargs={
            "ClientRequestToken": client_request_token,
            "FileSystemType": file_system_type,
            "StorageCapacity": storage_capacity,
            "StorageType": storage_type,
            "SubnetIds": subnet_ids,
            "SecurityGroupIds": security_group_ids,
            "Tags": tags,
            "KmsKeyId": kms_key_id,
            "WindowsConfiguration": windows_configuration,
            "LustreConfiguration": lustre_configuration,
        },
    )


async def delete(
    hub,
    ctx,
    file_system_id: str,
    client_request_token: str = None,
    windows_configuration: Dict = None,
    lustre_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a file system, deleting its contents. After deletion, the file system no longer exists, and its data is gone. Any existing automatic backups will also be deleted. By default, when you delete an Amazon FSx for Windows File Server file system, a final backup is created upon deletion. This final backup is not subject to the file system's retention policy, and must be manually deleted. The DeleteFileSystem action returns while the file system has the DELETING status. You can check the file system deletion status by calling the DescribeFileSystems action, which returns a list of file systems in your account. If you pass the file system ID for a deleted file system, the DescribeFileSystems returns a FileSystemNotFound error.  Deleting an Amazon FSx for Lustre file system will fail with a 400 BadRequest if a data repository task is in a PENDING or EXECUTING state.   The data in a deleted file system is also deleted and can't be recovered by any means.

    Args:
        file_system_id(str): The ID of the file system you want to delete.
        client_request_token(str, optional): A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This is automatically filled on your behalf when using the AWS CLI or SDK. Defaults to None.
        windows_configuration(Dict, optional): The configuration object for the Microsoft Windows file system used in the DeleteFileSystem operation. Defaults to None.
        lustre_configuration(Dict, optional): The configuration object for the Amazon FSx for Lustre file system being deleted in the DeleteFileSystem operation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fsx.file_system.init.delete(ctx, file_system_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fsx.file_system.init.delete file_system_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fsx",
        operation="delete_file_system",
        op_kwargs={
            "FileSystemId": file_system_id,
            "ClientRequestToken": client_request_token,
            "WindowsConfiguration": windows_configuration,
            "LustreConfiguration": lustre_configuration,
        },
    )


async def describe_all(
    hub,
    ctx,
    file_system_ids: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the description of specific Amazon FSx file systems, if a FileSystemIds value is provided for that file system. Otherwise, it returns descriptions of all file systems owned by your AWS account in the AWS Region of the endpoint that you're calling. When retrieving all file system descriptions, you can optionally specify the MaxResults parameter to limit the number of descriptions in a response. If more file system descriptions remain, Amazon FSx returns a NextToken value in the response. In this case, send a later request with the NextToken request parameter set to the value of NextToken from the last response. This action is used in an iterative process to retrieve a list of your file system descriptions. DescribeFileSystems is called first without a NextTokenvalue. Then the action continues to be called with the NextToken parameter set to the value of the last NextToken value until a response has no NextToken. When using this action, keep the following in mind:   The implementation might return fewer than MaxResults file system descriptions while still including a NextToken value.   The order of file systems returned in the response of one DescribeFileSystems call and the order of file systems returned across the responses of a multicall iteration is unspecified.

    Args:
        file_system_ids(List, optional): IDs of the file systems whose descriptions you want to retrieve (String). Defaults to None.
        max_results(int, optional): Maximum number of file systems to return in the response (integer). This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the MaxResults parameter specified in the request and the service's internal maximum number of items per page. Defaults to None.
        next_token(str, optional): Opaque pagination token returned from a previous DescribeFileSystems operation (String). If a token present, the action continues the list from where the returning call left off. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fsx.file_system.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fsx.file_system.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fsx",
        operation="describe_file_systems",
        op_kwargs={
            "FileSystemIds": file_system_ids,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    file_system_id: str,
    client_request_token: str = None,
    storage_capacity: int = None,
    windows_configuration: Dict = None,
    lustre_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Use this operation to update the configuration of an existing Amazon FSx file system. You can update multiple properties in a single request. For Amazon FSx for Windows File Server file systems, you can update the following properties:   AuditLogConfiguration   AutomaticBackupRetentionDays   DailyAutomaticBackupStartTime   SelfManagedActiveDirectoryConfiguration   StorageCapacity   ThroughputCapacity   WeeklyMaintenanceStartTime   For Amazon FSx for Lustre file systems, you can update the following properties:   AutoImportPolicy   AutomaticBackupRetentionDays   DailyAutomaticBackupStartTime   DataCompressionType   StorageCapacity   WeeklyMaintenanceStartTime

    Args:
        file_system_id(str): Identifies the file system that you are updating.
        client_request_token(str, optional): A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent updates. This string is automatically filled on your behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK. Defaults to None.
        storage_capacity(int, optional): Use this parameter to increase the storage capacity of an Amazon FSx file system. Specifies the storage capacity target value, GiB, to increase the storage capacity for the file system that you're updating. You cannot make a storage capacity increase request if there is an existing storage capacity increase request in progress. For Windows file systems, the storage capacity target value must be at least 10 percent (%) greater than the current storage capacity value. In order to increase storage capacity, the file system must have at least 16 MB/s of throughput capacity. For Lustre file systems, the storage capacity target value can be the following:   For SCRATCH_2 and PERSISTENT_1 SSD deployment types, valid values are in multiples of 2400 GiB. The value must be greater than the current storage capacity.   For PERSISTENT HDD file systems, valid values are multiples of 6000 GiB for 12 MB/s/TiB file systems and multiples of 1800 GiB for 40 MB/s/TiB file systems. The values must be greater than the current storage capacity.   For SCRATCH_1 file systems, you cannot increase the storage capacity.   For more information, see Managing storage capacity in the Amazon FSx for Windows File Server User Guide and Managing storage and throughput capacity in the Amazon FSx for Lustre User Guide. Defaults to None.
        windows_configuration(Dict, optional): The configuration updates for an Amazon FSx for Windows File Server file system. Defaults to None.
        lustre_configuration(Dict, optional): The configuration object for Amazon FSx for Lustre file systems used in the UpdateFileSystem operation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fsx.file_system.init.update(ctx, file_system_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fsx.file_system.init.update file_system_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fsx",
        operation="update_file_system",
        op_kwargs={
            "FileSystemId": file_system_id,
            "ClientRequestToken": client_request_token,
            "StorageCapacity": storage_capacity,
            "WindowsConfiguration": windows_configuration,
            "LustreConfiguration": lustre_configuration,
        },
    )
