"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    backup_id: str,
    subnet_ids: List,
    client_request_token: str = None,
    security_group_ids: List = None,
    tags: List = None,
    windows_configuration: Dict = None,
    lustre_configuration: Dict = None,
    storage_type: str = None,
    kms_key_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Amazon FSx file system from an existing Amazon FSx backup. If a file system with the specified client request token exists and the parameters match, this operation returns the description of the file system. If a client request token specified by the file system exists and the parameters don't match, this call returns IncompatibleParameterError. If a file system with the specified client request token doesn't exist, this operation does the following:   Creates a new Amazon FSx file system from backup with an assigned ID, and an initial lifecycle state of CREATING.   Returns the description of the file system.   Parameters like Active Directory, default share name, automatic backup, and backup settings default to the parameters of the file system that was backed up, unless overridden. You can explicitly supply other settings. By using the idempotent operation, you can retry a CreateFileSystemFromBackup call without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives success as long as the parameters are the same.  The CreateFileSystemFromBackup call returns while the file system's lifecycle state is still CREATING. You can check the file-system creation status by calling the DescribeFileSystems operation, which returns the file system state along with other information.

    Args:
        backup_id(str): The ID of the source backup. Specifies the backup you are copying.
        client_request_token(str, optional): A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK. Defaults to None.
        subnet_ids(List): Specifies the IDs of the subnets that the file system will be accessible from. For Windows MULTI_AZ_1 file system deployment types, provide exactly two subnet IDs, one for the preferred file server and one for the standby file server. You specify one of these subnets as the preferred subnet using the WindowsConfiguration > PreferredSubnetID property. For Windows SINGLE_AZ_1 and SINGLE_AZ_2 deployment types and Lustre file systems, provide exactly one subnet ID. The file server is launched in that subnet's Availability Zone.
        security_group_ids(List, optional): A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups apply to all network interfaces. This value isn't returned in later DescribeFileSystem requests. Defaults to None.
        tags(List, optional): The tags to be applied to the file system at file system creation. The key value of the Name tag appears in the console as the file system name. Defaults to None.
        windows_configuration(Dict, optional): The configuration for this Microsoft Windows file system. Defaults to None.
        lustre_configuration(Dict, optional): The Lustre configuration for the file system being created. . Defaults to None.
        storage_type(str, optional): Sets the storage type for the Windows file system you're creating from a backup. Valid values are SSD and HDD.   Set to SSD to use solid state drive storage. Supported on all Windows deployment types.   Set to HDD to use hard disk drive storage. Supported on SINGLE_AZ_2 and MULTI_AZ_1 Windows file system deployment types.     Default value is SSD.   HDD and SSD storage types have different minimum storage capacity requirements. A restored file system's storage capacity is tied to the file system that was backed up. You can create a file system that uses HDD storage from a backup of a file system that used SSD storage only if the original SSD file system had a storage capacity of at least 2000 GiB.  . Defaults to None.
        kms_key_id(str, optional): The ID of the AWS Key Management Service (AWS KMS) key used to encrypt the file system's data for Amazon FSx for Windows File Server file systems and Amazon FSx for Lustre PERSISTENT_1 file systems at rest. In either case, if not specified, the Amazon FSx managed key is used. The Amazon FSx for Lustre SCRATCH_1 and SCRATCH_2 file systems are always encrypted at rest using Amazon FSx managed keys. For more information, see Encrypt in the AWS Key Management Service API Reference. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fsx.file_system.from_backup.create(
                ctx, backup_id=value, subnet_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fsx.file_system.from_backup.create backup_id=value, subnet_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fsx",
        operation="create_file_system_from_backup",
        op_kwargs={
            "BackupId": backup_id,
            "ClientRequestToken": client_request_token,
            "SubnetIds": subnet_ids,
            "SecurityGroupIds": security_group_ids,
            "Tags": tags,
            "WindowsConfiguration": windows_configuration,
            "LustreConfiguration": lustre_configuration,
            "StorageType": storage_type,
            "KmsKeyId": kms_key_id,
        },
    )
