"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub, ctx, file_system_id: str, aliases: List, client_request_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Use this action to associate one or more Domain Name Server (DNS) aliases with an existing Amazon FSx for Windows File Server file system. A file systen can have a maximum of 50 DNS aliases associated with it at any one time. If you try to associate a DNS alias that is already associated with the file system, FSx takes no action on that alias in the request. For more information, see Working with DNS Aliases and Walkthrough 5: Using DNS aliases to access your file system, including additional steps you must take to be able to access your file system using a DNS alias. The system response shows the DNS aliases that Amazon FSx is attempting to associate with the file system. Use the API operation to monitor the status of the aliases Amazon FSx is associating with the file system.

    Args:
        client_request_token(str, optional): (Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK. Defaults to None.
        file_system_id(str): Specifies the file system with which you want to associate one or more DNS aliases.
        aliases(List): An array of one or more DNS alias names to associate with the file system. The alias name has to comply with the following formatting requirements:   Formatted as a fully-qualified domain name (FQDN),  hostname.domain , for example, accounting.corp.example.com.   Can contain alphanumeric characters and the hyphen (-).   Cannot start or end with a hyphen.   Can start with a numeric.   For DNS alias names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them: as uppercase letters, lowercase letters, or the corresponding letters in escape codes.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fsx.file_system.aliase.associate(
                ctx, file_system_id=value, aliases=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fsx.file_system.aliase.associate file_system_id=value, aliases=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fsx",
        operation="associate_file_system_aliases",
        op_kwargs={
            "ClientRequestToken": client_request_token,
            "FileSystemId": file_system_id,
            "Aliases": aliases,
        },
    )


async def describe_all(
    hub,
    ctx,
    file_system_id: str,
    client_request_token: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the DNS aliases that are associated with the specified Amazon FSx for Windows File Server file system. A history of all DNS aliases that have been associated with and disassociated from the file system is available in the list of AdministrativeAction provided in the DescribeFileSystems operation response.

    Args:
        client_request_token(str, optional): (Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK. Defaults to None.
        file_system_id(str): The ID of the file system to return the associated DNS aliases for (String).
        max_results(int, optional): Maximum number of DNS aliases to return in the response (integer). This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the MaxResults parameter specified in the request and the service's internal maximum number of items per page. Defaults to None.
        next_token(str, optional): Opaque pagination token returned from a previous DescribeFileSystemAliases operation (String). If a token is included in the request, the action continues the list from where the previous returning call left off. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fsx.file_system.aliase.describe_all(ctx, file_system_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fsx.file_system.aliase.describe_all file_system_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fsx",
        operation="describe_file_system_aliases",
        op_kwargs={
            "ClientRequestToken": client_request_token,
            "FileSystemId": file_system_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def disassociate(
    hub, ctx, file_system_id: str, aliases: List, client_request_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Use this action to disassociate, or remove, one or more Domain Name Service (DNS) aliases from an Amazon FSx for Windows File Server file system. If you attempt to disassociate a DNS alias that is not associated with the file system, Amazon FSx responds with a 400 Bad Request. For more information, see Working with DNS Aliases. The system generated response showing the DNS aliases that Amazon FSx is attempting to disassociate from the file system. Use the API operation to monitor the status of the aliases Amazon FSx is disassociating with the file system.

    Args:
        client_request_token(str, optional): (Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK. Defaults to None.
        file_system_id(str): Specifies the file system from which to disassociate the DNS aliases.
        aliases(List): An array of one or more DNS alias names to disassociate, or remove, from the file system.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fsx.file_system.aliase.disassociate(
                ctx, file_system_id=value, aliases=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fsx.file_system.aliase.disassociate file_system_id=value, aliases=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fsx",
        operation="disassociate_file_system_aliases",
        op_kwargs={
            "ClientRequestToken": client_request_token,
            "FileSystemId": file_system_id,
            "Aliases": aliases,
        },
    )
