"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, task_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels an existing Amazon FSx for Lustre data repository task if that task is in either the PENDING or EXECUTING state. When you cancel a task, Amazon FSx does the following.   Any files that FSx has already exported are not reverted.   FSx continues to export any files that are "in-flight" when the cancel operation is received.   FSx does not export any files that have not yet been exported.

    Args:
        task_id(str): Specifies the data repository task to cancel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fsx.data_repository_task.cancel(ctx, task_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fsx.data_repository_task.cancel task_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fsx",
        operation="cancel_data_repository_task",
        op_kwargs={"TaskId": task_id},
    )


async def create(
    hub,
    ctx,
    type_: str,
    file_system_id: str,
    report: Dict,
    paths: List = None,
    client_request_token: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon FSx for Lustre data repository task. You use data repository tasks to perform bulk operations between your Amazon FSx file system and its linked data repository. An example of a data repository task is exporting any data and metadata changes, including POSIX metadata, to files, directories, and symbolic links (symlinks) from your FSx file system to its linked data repository. A CreateDataRepositoryTask operation will fail if a data repository is not linked to the FSx file system. To learn more about data repository tasks, see Data Repository Tasks. To learn more about linking a data repository to your file system, see Linking your file system to an S3 bucket.

    Args:
        type_(str): Specifies the type of data repository task to create.
        paths(List, optional): (Optional) The path or paths on the Amazon FSx file system to use when the data repository task is processed. The default path is the file system root directory. The paths you provide need to be relative to the mount point of the file system. If the mount point is /mnt/fsx and /mnt/fsx/path1 is a directory or file on the file system you want to export, then the path to provide is path1. If a path that you provide isn't valid, the task fails. Defaults to None.
        file_system_id(str): The globally unique ID of the file system, assigned by Amazon FSx.
        report(Dict): Defines whether or not Amazon FSx provides a CompletionReport once the task has completed. A CompletionReport provides a detailed report on the files that Amazon FSx processed that meet the criteria specified by the Scope parameter. For more information, see Working with Task Completion Reports.
        client_request_token(str, optional): (Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK. Defaults to None.
        tags(List, optional): A list of Tag values, with a maximum of 50 elements. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fsx.data_repository_task.create(
                ctx, type_=value, file_system_id=value, report=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fsx.data_repository_task.create type_=value, file_system_id=value, report=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fsx",
        operation="create_data_repository_task",
        op_kwargs={
            "Type": type_,
            "Paths": paths,
            "FileSystemId": file_system_id,
            "Report": report,
            "ClientRequestToken": client_request_token,
            "Tags": tags,
        },
    )


async def describe_all(
    hub,
    ctx,
    task_ids: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the description of specific Amazon FSx for Lustre data repository tasks, if one or more TaskIds values are provided in the request, or if filters are used in the request. You can use filters to narrow the response to include just tasks for specific file systems, or tasks in a specific lifecycle state. Otherwise, it returns all data repository tasks owned by your AWS account in the AWS Region of the endpoint that you're calling. When retrieving all tasks, you can paginate the response by using the optional MaxResults parameter to limit the number of tasks returned in a response. If more tasks remain, Amazon FSx returns a NextToken value in the response. In this case, send a later request with the NextToken request parameter set to the value of NextToken from the last response.

    Args:
        task_ids(List, optional): (Optional) IDs of the tasks whose descriptions you want to retrieve (String). Defaults to None.
        filters(List, optional): (Optional) You can use filters to narrow the DescribeDataRepositoryTasks response to include just tasks for specific file systems, or tasks in a specific lifecycle state. Defaults to None.
        max_results(int, optional): The maximum number of resources to return in the response. This value must be an integer greater than zero. Defaults to None.
        next_token(str, optional): (Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous NextToken value left off. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fsx.data_repository_task.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fsx.data_repository_task.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fsx",
        operation="describe_data_repository_tasks",
        op_kwargs={
            "TaskIds": task_ids,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
