"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def copy(
    hub,
    ctx,
    source_backup_id: str,
    client_request_token: str = None,
    source_region: str = None,
    kms_key_id: str = None,
    copy_tags: bool = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Copies an existing backup within the same AWS account to another Region (cross-Region copy) or within the same Region (in-Region copy). You can have up to five backup copy requests in progress to a single destination Region per account. You can use cross-Region backup copies for cross-region disaster recovery. You periodically take backups and copy them to another Region so that in the event of a disaster in the primary Region, you can restore from backup and recover availability quickly in the other Region. You can make cross-Region copies only within your AWS partition.  You can also use backup copies to clone your file data set to another Region or within the same Region. You can use the SourceRegion parameter to specify the AWS Region from which the backup will be copied. For example, if you make the call from the us-west-1 Region and want to copy a backup from the us-east-2 Region, you specify us-east-2 in the SourceRegion parameter to make a cross-Region copy. If you don't specify a Region, the backup copy is created in the same Region where the request is sent from (in-Region copy). For more information on creating backup copies, see  Copying backups in the Amazon FSx for Windows User Guide and Copying backups in the Amazon FSx for Lustre User Guide.

    Args:
        client_request_token(str, optional): (Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK. Defaults to None.
        source_backup_id(str): The ID of the source backup. Specifies the ID of the backup that is being copied.
        source_region(str, optional): The source AWS Region of the backup. Specifies the AWS Region from which the backup is being copied. The source and destination Regions must be in the same AWS partition. If you don't specify a Region, it defaults to the Region where the request is sent from (in-Region copy). Defaults to None.
        kms_key_id(str, optional): The ID of the AWS Key Management Service (AWS KMS) key used to encrypt the file system's data for Amazon FSx for Windows File Server file systems and Amazon FSx for Lustre PERSISTENT_1 file systems at rest. In either case, if not specified, the Amazon FSx managed key is used. The Amazon FSx for Lustre SCRATCH_1 and SCRATCH_2 file systems are always encrypted at rest using Amazon FSx managed keys. For more information, see Encrypt in the AWS Key Management Service API Reference. Defaults to None.
        copy_tags(bool, optional): A boolean flag indicating whether tags from the source backup should be copied to the backup copy. This value defaults to false. If you set CopyTags to true and the source backup has existing tags, you can use the Tags parameter to create new tags, provided that the sum of the source backup tags and the new tags doesn't exceed 50. Both sets of tags are merged. If there are tag conflicts (for example, two tags with the same key but different values), the tags created with the Tags parameter take precedence. Defaults to None.
        tags(List, optional): A list of Tag values, with a maximum of 50 elements. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fsx.backup.copy(ctx, source_backup_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fsx.backup.copy source_backup_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fsx",
        operation="copy_backup",
        op_kwargs={
            "ClientRequestToken": client_request_token,
            "SourceBackupId": source_backup_id,
            "SourceRegion": source_region,
            "KmsKeyId": kms_key_id,
            "CopyTags": copy_tags,
            "Tags": tags,
        },
    )


async def create(
    hub, ctx, file_system_id: str, client_request_token: str = None, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a backup of an existing Amazon FSx file system. Creating regular backups for your file system is a best practice, enabling you to restore a file system from a backup if an issue arises with the original file system. For Amazon FSx for Lustre file systems, you can create a backup only for file systems with the following configuration:   a Persistent deployment type   is not linked to a data respository.   For more information about backing up Amazon FSx for Lustre file systems, see Working with FSx for Lustre backups. For more information about backing up Amazon FSx for Windows file systems, see Working with FSx for Windows backups. If a backup with the specified client request token exists, and the parameters match, this operation returns the description of the existing backup. If a backup specified client request token exists, and the parameters don't match, this operation returns IncompatibleParameterError. If a backup with the specified client request token doesn't exist, CreateBackup does the following:    Creates a new Amazon FSx backup with an assigned ID, and an initial lifecycle state of CREATING.   Returns the description of the backup.   By using the idempotent operation, you can retry a CreateBackup operation without the risk of creating an extra backup. This approach can be useful when an initial call fails in a way that makes it unclear whether a backup was created. If you use the same client request token and the initial call created a backup, the operation returns a successful result because all the parameters are the same. The CreateBackup operation returns while the backup's lifecycle state is still CREATING. You can check the backup creation status by calling the DescribeBackups operation, which returns the backup state along with other information.

    Args:
        file_system_id(str): The ID of the file system to back up.
        client_request_token(str, optional): (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK. Defaults to None.
        tags(List, optional): (Optional) The tags to apply to the backup at backup creation. The key value of the Name tag appears in the console as the backup name. If you have set CopyTagsToBackups to true, and you specify one or more tags using the CreateBackup action, no existing file system tags are copied from the file system to the backup. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fsx.backup.create(ctx, file_system_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fsx.backup.create file_system_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fsx",
        operation="create_backup",
        op_kwargs={
            "FileSystemId": file_system_id,
            "ClientRequestToken": client_request_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, backup_id: str, client_request_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an Amazon FSx backup, deleting its contents. After deletion, the backup no longer exists, and its data is gone. The DeleteBackup call returns instantly. The backup will not show up in later DescribeBackups calls.  The data in a deleted backup is also deleted and can't be recovered by any means.

    Args:
        backup_id(str): The ID of the backup you want to delete.
        client_request_token(str, optional): A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This is automatically filled on your behalf when using the AWS CLI or SDK. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fsx.backup.delete(ctx, backup_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fsx.backup.delete backup_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fsx",
        operation="delete_backup",
        op_kwargs={"BackupId": backup_id, "ClientRequestToken": client_request_token},
    )


async def describe_all(
    hub,
    ctx,
    backup_ids: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the description of specific Amazon FSx backups, if a BackupIds value is provided for that backup. Otherwise, it returns all backups owned by your AWS account in the AWS Region of the endpoint that you're calling. When retrieving all backups, you can optionally specify the MaxResults parameter to limit the number of backups in a response. If more backups remain, Amazon FSx returns a NextToken value in the response. In this case, send a later request with the NextToken request parameter set to the value of NextToken from the last response. This action is used in an iterative process to retrieve a list of your backups. DescribeBackups is called first without a NextTokenvalue. Then the action continues to be called with the NextToken parameter set to the value of the last NextToken value until a response has no NextToken. When using this action, keep the following in mind:   The implementation might return fewer than MaxResults file system descriptions while still including a NextToken value.   The order of backups returned in the response of one DescribeBackups call and the order of backups returned across the responses of a multi-call iteration is unspecified.

    Args:
        backup_ids(List, optional): IDs of the backups you want to retrieve (String). This overrides any filters. If any IDs are not found, BackupNotFound will be thrown. Defaults to None.
        filters(List, optional): Filters structure. Supported names are file-system-id and backup-type. Defaults to None.
        max_results(int, optional): Maximum number of backups to return in the response (integer). This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the MaxResults parameter specified in the request and the service's internal maximum number of items per page. Defaults to None.
        next_token(str, optional): Opaque pagination token returned from a previous DescribeBackups operation (String). If a token present, the action continues the list from where the returning call left off. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fsx.backup.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fsx.backup.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fsx",
        operation="describe_backups",
        op_kwargs={
            "BackupIds": backup_ids,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
