"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    data_type: str,
    data_source: str,
    default_value: str,
    description: str = None,
    variable_type: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a variable.

    Args:
        name(str): The name of the variable.
        data_type(str): The data type.
        data_source(str): The source of the data.
        default_value(str): The default value for the variable when no value is received.
        description(str, optional): The description. Defaults to None.
        variable_type(str, optional): The variable type. For more information see Variable types.  Valid Values: AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT . Defaults to None.
        tags(List, optional): A collection of key and value pairs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.variable.create(
                ctx, name=value, data_type=value, data_source=value, default_value=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.variable.create name=value, data_type=value, data_source=value, default_value=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="create_variable",
        op_kwargs={
            "name": name,
            "dataType": data_type,
            "dataSource": data_source,
            "defaultValue": default_value,
            "description": description,
            "variableType": variable_type,
            "tags": tags,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a variable. You can't delete variables that are included in an event type in Amazon Fraud Detector. Amazon Fraud Detector automatically deletes model output variables and SageMaker model output variables when you delete the model. You can't delete these variables manually. When you delete a variable, Amazon Fraud Detector permanently deletes that variable and the data is no longer stored in Amazon Fraud Detector.

    Args:
        name(str): The name of the variable to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.variable.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.variable.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="delete_variable",
        op_kwargs={"name": name},
    )


async def get_all(
    hub, ctx, name: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets all of the variables or the specific variable. This is a paginated API. Providing null maxSizePerPage results in retrieving maximum of 100 records per page. If you provide maxSizePerPage the value must be between 50 and 100. To get the next page result, a provide a pagination token from GetVariablesResult as part of your request. Null pagination token fetches the records from the beginning.

    Args:
        name(str, optional): The name of the variable. . Defaults to None.
        next_token(str, optional): The next page token of the get variable request. . Defaults to None.
        max_results(int, optional): The max size per page determined for the get variable request. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.variable.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.variable.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="get_variables",
        op_kwargs={"name": name, "nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub,
    ctx,
    name: str,
    default_value: str = None,
    description: str = None,
    variable_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a variable.

    Args:
        name(str): The name of the variable.
        default_value(str, optional): The new default value of the variable. Defaults to None.
        description(str, optional): The new description. Defaults to None.
        variable_type(str, optional): The variable type. For more information see Variable types. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.variable.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.variable.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="update_variable",
        op_kwargs={
            "name": name,
            "defaultValue": default_value,
            "description": description,
            "variableType": variable_type,
        },
    )
