"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def update(
    hub,
    ctx,
    rule: Dict,
    expression: str,
    language: str,
    outcomes: List,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a rule version resulting in a new rule version. Updates a rule version resulting in a new rule version (version 1, 2, 3 ...).

    Args:
        rule(Dict): The rule to update.
        description(str, optional): The description. Defaults to None.
        expression(str): The rule expression.
        language(str): The language.
        outcomes(List): The outcomes.
        tags(List, optional): The tags to assign to the rule version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.rule.version.update(
                ctx, rule=value, expression=value, language=value, outcomes=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.rule.version.update rule=value, expression=value, language=value, outcomes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="update_rule_version",
        op_kwargs={
            "rule": rule,
            "description": description,
            "expression": expression,
            "language": language,
            "outcomes": outcomes,
            "tags": tags,
        },
    )
