"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, rule: Dict, description: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates a rule's metadata. The description attribute can be updated.

    Args:
        rule(Dict): The rule to update.
        description(str): The rule description.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.rule.metadata.update(
                ctx, rule=value, description=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.rule.metadata.update rule=value, description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="update_rule_metadata",
        op_kwargs={"rule": rule, "description": description},
    )
