"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    rule_id: str,
    detector_id: str,
    expression: str,
    language: str,
    outcomes: List,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a rule for use with the specified detector.

    Args:
        rule_id(str): The rule ID.
        detector_id(str): The detector ID for the rule's parent detector.
        description(str, optional): The rule description. Defaults to None.
        expression(str): The rule expression.
        language(str): The language of the rule.
        outcomes(List): The outcome or outcomes returned when the rule expression matches.
        tags(List, optional): A collection of key and value pairs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.rule.init.create(
                ctx,
                rule_id=value,
                detector_id=value,
                expression=value,
                language=value,
                outcomes=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.rule.init.create rule_id=value, detector_id=value, expression=value, language=value, outcomes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="create_rule",
        op_kwargs={
            "ruleId": rule_id,
            "detectorId": detector_id,
            "description": description,
            "expression": expression,
            "language": language,
            "outcomes": outcomes,
            "tags": tags,
        },
    )


async def delete(hub, ctx, rule: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the rule. You cannot delete a rule if it is used by an ACTIVE or INACTIVE detector version. When you delete a rule, Amazon Fraud Detector permanently deletes that rule and the data is no longer stored in Amazon Fraud Detector.

    Args:
        rule(Dict): A rule.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.rule.init.delete(ctx, rule=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.rule.init.delete rule=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="delete_rule",
        op_kwargs={"rule": rule},
    )


async def get_all(
    hub,
    ctx,
    detector_id: str,
    rule_id: str = None,
    rule_version: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Get all rules for a detector (paginated) if ruleId and ruleVersion are not specified. Gets all rules for the detector and the ruleId if present (paginated). Gets a specific rule if both the ruleId and the ruleVersion are specified. This is a paginated API. Providing null maxResults results in retrieving maximum of 100 records per page. If you provide maxResults the value must be between 50 and 100. To get the next page result, a provide a pagination token from GetRulesResult as part of your request. Null pagination token fetches the records from the beginning.

    Args:
        rule_id(str, optional): The rule ID. Defaults to None.
        detector_id(str): The detector ID.
        rule_version(str, optional): The rule version. Defaults to None.
        next_token(str, optional): The next page token. Defaults to None.
        max_results(int, optional): The maximum number of rules to return for the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.rule.init.get_all(ctx, detector_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.rule.init.get_all detector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="get_rules",
        op_kwargs={
            "ruleId": rule_id,
            "detectorId": detector_id,
            "ruleVersion": rule_version,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
