"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an outcome. You cannot delete an outcome that is used in a rule version. When you delete an outcome, Amazon Fraud Detector permanently deletes that outcome and the data is no longer stored in Amazon Fraud Detector.

    Args:
        name(str): The name of the outcome to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.outcome.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.outcome.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="delete_outcome",
        op_kwargs={"name": name},
    )


async def get_all(
    hub, ctx, name: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets one or more outcomes. This is a paginated API. If you provide a null maxResults, this actions retrieves a maximum of 100 records per page. If you provide a maxResults, the value must be between 50 and 100. To get the next page results, provide the pagination token from the GetOutcomesResult as part of your request. A null pagination token fetches the records from the beginning.

    Args:
        name(str, optional): The name of the outcome or outcomes to get. Defaults to None.
        next_token(str, optional): The next page token for the request. . Defaults to None.
        max_results(int, optional): The maximum number of objects to return for the request. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.outcome.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.outcome.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="get_outcomes",
        op_kwargs={"name": name, "nextToken": next_token, "maxResults": max_results},
    )


async def put(hub, ctx, name: str, description: str = None, tags: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates an outcome.

    Args:
        name(str): The name of the outcome.
        description(str, optional): The outcome description. Defaults to None.
        tags(List, optional): A collection of key and value pairs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.outcome.put(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.outcome.put name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="put_outcome",
        op_kwargs={"name": name, "description": description, "tags": tags},
    )
