"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, model_id: str, model_type: str, model_version_number: str, status: str
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the status of a model version. You can perform the following status updates:   Change the TRAINING_COMPLETE status to ACTIVE.   Change ACTIVEto INACTIVE.

    Args:
        model_id(str): The model ID of the model version to update.
        model_type(str): The model type.
        model_version_number(str): The model version number.
        status(str): The model version status.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.model.version.status.update(
                ctx, model_id=value, model_type=value, model_version_number=value, status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.model.version.status.update model_id=value, model_type=value, model_version_number=value, status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="update_model_version_status",
        op_kwargs={
            "modelId": model_id,
            "modelType": model_type,
            "modelVersionNumber": model_version_number,
            "status": status,
        },
    )
