"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    model_id: str,
    model_type: str,
    training_data_source: str,
    training_data_schema: Dict,
    external_events_detail: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a version of the model using the specified model type and model id.

    Args:
        model_id(str): The model ID. .
        model_type(str): The model type.
        training_data_source(str): The training data source location in Amazon S3. .
        training_data_schema(Dict): The training data schema.
        external_events_detail(Dict, optional): Details for the external events data used for model version training. Required if trainingDataSource is EXTERNAL_EVENTS. Defaults to None.
        tags(List, optional): A collection of key and value pairs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.model.version.init.create(
                ctx,
                model_id=value,
                model_type=value,
                training_data_source=value,
                training_data_schema=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.model.version.init.create model_id=value, model_type=value, training_data_source=value, training_data_schema=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="create_model_version",
        op_kwargs={
            "modelId": model_id,
            "modelType": model_type,
            "trainingDataSource": training_data_source,
            "trainingDataSchema": training_data_schema,
            "externalEventsDetail": external_events_detail,
            "tags": tags,
        },
    )


async def delete(
    hub, ctx, model_id: str, model_type: str, model_version_number: str
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a model version. You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a detector version.  When you delete a model version, Amazon Fraud Detector permanently deletes that model version and the data is no longer stored in Amazon Fraud Detector.

    Args:
        model_id(str): The model ID of the model version to delete.
        model_type(str): The model type of the model version to delete.
        model_version_number(str): The model version number of the model version to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.model.version.init.delete(
                ctx, model_id=value, model_type=value, model_version_number=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.model.version.init.delete model_id=value, model_type=value, model_version_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="delete_model_version",
        op_kwargs={
            "modelId": model_id,
            "modelType": model_type,
            "modelVersionNumber": model_version_number,
        },
    )


async def describe_all(
    hub,
    ctx,
    model_id: str = None,
    model_version_number: str = None,
    model_type: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets all of the model versions for the specified model type or for the specified model type and model ID. You can also get details for a single, specified model version.

    Args:
        model_id(str, optional): The model ID. Defaults to None.
        model_version_number(str, optional): The model version number. Defaults to None.
        model_type(str, optional): The model type. Defaults to None.
        next_token(str, optional): The next token from the previous results. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.model.version.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.model.version.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="describe_model_versions",
        op_kwargs={
            "modelId": model_id,
            "modelVersionNumber": model_version_number,
            "modelType": model_type,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def get(
    hub, ctx, model_id: str, model_type: str, model_version_number: str
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the details of the specified model version.

    Args:
        model_id(str): The model ID.
        model_type(str): The model type.
        model_version_number(str): The model version number.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.model.version.init.get(
                ctx, model_id=value, model_type=value, model_version_number=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.model.version.init.get model_id=value, model_type=value, model_version_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="get_model_version",
        op_kwargs={
            "modelId": model_id,
            "modelType": model_type,
            "modelVersionNumber": model_version_number,
        },
    )


async def update(
    hub,
    ctx,
    model_id: str,
    model_type: str,
    major_version_number: str,
    external_events_detail: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a model version. Updating a model version retrains an existing model version using updated training data and produces a new minor version of the model. You can update the training data set location and data access role attributes using this action. This action creates and trains a new minor version of the model, for example version 1.01, 1.02, 1.03.

    Args:
        model_id(str): The model ID.
        model_type(str): The model type.
        major_version_number(str): The major version number.
        external_events_detail(Dict, optional): The event details. Defaults to None.
        tags(List, optional): A collection of key and value pairs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.model.version.init.update(
                ctx, model_id=value, model_type=value, major_version_number=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.model.version.init.update model_id=value, model_type=value, major_version_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="update_model_version",
        op_kwargs={
            "modelId": model_id,
            "modelType": model_type,
            "majorVersionNumber": major_version_number,
            "externalEventsDetail": external_events_detail,
            "tags": tags,
        },
    )
