"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    model_id: str,
    model_type: str,
    event_type_name: str,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a model using the specified model type.

    Args:
        model_id(str): The model ID.
        model_type(str): The model type. .
        description(str, optional): The model description. . Defaults to None.
        event_type_name(str): The name of the event type.
        tags(List, optional): A collection of key and value pairs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.model.init.create(
                ctx, model_id=value, model_type=value, event_type_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.model.init.create model_id=value, model_type=value, event_type_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="create_model",
        op_kwargs={
            "modelId": model_id,
            "modelType": model_type,
            "description": description,
            "eventTypeName": event_type_name,
            "tags": tags,
        },
    )


async def delete(hub, ctx, model_id: str, model_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a model. You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a detector version.  When you delete a model, Amazon Fraud Detector permanently deletes that model and the data is no longer stored in Amazon Fraud Detector.

    Args:
        model_id(str): The model ID of the model to delete.
        model_type(str): The model type of the model to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.model.init.delete(
                ctx, model_id=value, model_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.model.init.delete model_id=value, model_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="delete_model",
        op_kwargs={"modelId": model_id, "modelType": model_type},
    )


async def get_all(
    hub,
    ctx,
    model_id: str = None,
    model_type: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets one or more models. Gets all models for the AWS account if no model type and no model id provided. Gets all models for the AWS account and model type, if the model type is specified but model id is not provided. Gets a specific model if (model type, model id) tuple is specified.  This is a paginated API. If you provide a null maxResults, this action retrieves a maximum of 10 records per page. If you provide a maxResults, the value must be between 1 and 10. To get the next page results, provide the pagination token from the response as part of your request. A null pagination token fetches the records from the beginning.

    Args:
        model_id(str, optional): The model ID. Defaults to None.
        model_type(str, optional): The model type. Defaults to None.
        next_token(str, optional): The next token for the subsequent request. Defaults to None.
        max_results(int, optional): The maximum number of objects to return for the request. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.model.init.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.model.init.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="get_models",
        op_kwargs={
            "modelId": model_id,
            "modelType": model_type,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def update(
    hub, ctx, model_id: str, model_type: str, description: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a model. You can update the description attribute using this action.

    Args:
        model_id(str): The model ID.
        model_type(str): The model type.
        description(str, optional): The new model description. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.model.init.update(
                ctx, model_id=value, model_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.model.init.update model_id=value, model_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="update_model",
        op_kwargs={
            "modelId": model_id,
            "modelType": model_type,
            "description": description,
        },
    )
