"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Gets the encryption key if a Key Management Service (KMS) customer master key (CMK) has been specified to be used to encrypt content in Amazon Fraud Detector.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.kms_encryption_key.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.kms_encryption_key.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="get_kms_encryption_key",
        op_kwargs={},
    )


async def put(hub, ctx, kms_encryption_key_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Specifies the Key Management Service (KMS) customer master key (CMK) to be used to encrypt content in Amazon Fraud Detector.

    Args:
        kms_encryption_key_arn(str): The KMS encryption key ARN.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.kms_encryption_key.put(
                ctx, kms_encryption_key_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.kms_encryption_key.put kms_encryption_key_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="put_kms_encryption_key",
        op_kwargs={"kmsEncryptionKeyArn": kms_encryption_key_arn},
    )
