"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, names: List) -> Dict:
    r"""
    **Autogenerated function**

    Gets a batch of variables.

    Args:
        names(List): The list of variable names to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.get_variable.batch(ctx, names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.get_variable.batch names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="batch_get_variable",
        op_kwargs={"names": names},
    )
