"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, model_endpoint: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes a SageMaker model from Amazon Fraud Detector. You can remove an Amazon SageMaker model if it is not associated with a detector version. Removing a SageMaker model disconnects it from Amazon Fraud Detector, but the model remains available in SageMaker.

    Args:
        model_endpoint(str): The endpoint of the Amazon Sagemaker model to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.external_model.delete(ctx, model_endpoint=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.external_model.delete model_endpoint=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="delete_external_model",
        op_kwargs={"modelEndpoint": model_endpoint},
    )


async def get_all(
    hub,
    ctx,
    model_endpoint: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a paginated API. If you provide a null maxResults, this actions retrieves a maximum of 10 records per page. If you provide a maxResults, the value must be between 5 and 10. To get the next page results, provide the pagination token from the GetExternalModelsResult as part of your request. A null pagination token fetches the records from the beginning.

    Args:
        model_endpoint(str, optional): The Amazon SageMaker model endpoint. Defaults to None.
        next_token(str, optional): The next page token for the request. Defaults to None.
        max_results(int, optional): The maximum number of objects to return for the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.external_model.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.external_model.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="get_external_models",
        op_kwargs={
            "modelEndpoint": model_endpoint,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def put(
    hub,
    ctx,
    model_endpoint: str,
    model_source: str,
    invoke_model_endpoint_role_arn: str,
    input_configuration: Dict,
    output_configuration: Dict,
    model_endpoint_status: str,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates an Amazon SageMaker model endpoint. You can also use this action to update the configuration of the model endpoint, including the IAM role and/or the mapped variables.

    Args:
        model_endpoint(str): The model endpoints name.
        model_source(str): The source of the model.
        invoke_model_endpoint_role_arn(str): The IAM role used to invoke the model endpoint.
        input_configuration(Dict): The model endpoint input configuration.
        output_configuration(Dict): The model endpoint output configuration.
        model_endpoint_status(str): The model endpoint’s status in Amazon Fraud Detector.
        tags(List, optional): A collection of key and value pairs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.external_model.put(
                ctx,
                model_endpoint=value,
                model_source=value,
                invoke_model_endpoint_role_arn=value,
                input_configuration=value,
                output_configuration=value,
                model_endpoint_status=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.external_model.put model_endpoint=value, model_source=value, invoke_model_endpoint_role_arn=value, input_configuration=value, output_configuration=value, model_endpoint_status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="put_external_model",
        op_kwargs={
            "modelEndpoint": model_endpoint,
            "modelSource": model_source,
            "invokeModelEndpointRoleArn": invoke_model_endpoint_role_arn,
            "inputConfiguration": input_configuration,
            "outputConfiguration": output_configuration,
            "modelEndpointStatus": model_endpoint_status,
            "tags": tags,
        },
    )
