"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "type"


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an event type. You cannot delete an event type that is used in a detector or a model. When you delete an entity type, Amazon Fraud Detector permanently deletes that entity type and the data is no longer stored in Amazon Fraud Detector.

    Args:
        name(str): The name of the event type to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.event.type_.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.event.type.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="delete_event_type",
        op_kwargs={"name": name},
    )


async def get_all(
    hub, ctx, name: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets all event types or a specific event type if name is provided. This is a paginated API. If you provide a null maxResults, this action retrieves a maximum of 10 records per page. If you provide a maxResults, the value must be between 5 and 10. To get the next page results, provide the pagination token from the GetEventTypesResponse as part of your request. A null pagination token fetches the records from the beginning.

    Args:
        name(str, optional): The name. Defaults to None.
        next_token(str, optional): The next token for the subsequent request. Defaults to None.
        max_results(int, optional): The maximum number of objects to return for the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.event.type_.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.event.type.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="get_event_types",
        op_kwargs={"name": name, "nextToken": next_token, "maxResults": max_results},
    )


async def put(
    hub,
    ctx,
    name: str,
    event_variables: List,
    entity_types: List,
    description: str = None,
    labels: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates an event type. An event is a business activity that is evaluated for fraud risk. With Amazon Fraud Detector, you generate fraud predictions for events. An event type defines the structure for an event sent to Amazon Fraud Detector. This includes the variables sent as part of the event, the entity performing the event (such as a customer), and the labels that classify the event. Example event types include online payment transactions, account registrations, and authentications.

    Args:
        name(str): The name.
        description(str, optional): The description of the event type. Defaults to None.
        event_variables(List): The event type variables.
        labels(List, optional): The event type labels. Defaults to None.
        entity_types(List): The entity type for the event type. Example entity types: customer, merchant, account.
        tags(List, optional): A collection of key and value pairs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.event.type_.put(
                ctx, name=value, event_variables=value, entity_types=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.event.type.put name=value, event_variables=value, entity_types=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="put_event_type",
        op_kwargs={
            "name": name,
            "description": description,
            "eventVariables": event_variables,
            "labels": labels,
            "entityTypes": entity_types,
            "tags": tags,
        },
    )
