"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(
    hub,
    ctx,
    detector_id: str,
    event_id: str,
    event_type_name: str,
    entities: List,
    event_timestamp: str,
    event_variables: Dict,
    detector_version_id: str = None,
    external_model_endpoint_data_blobs: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Evaluates an event against a detector version. If a version ID is not provided, the detector’s (ACTIVE) version is used.

    Args:
        detector_id(str): The detector ID.
        detector_version_id(str, optional): The detector version ID. Defaults to None.
        event_id(str): The unique ID used to identify the event.
        event_type_name(str): The event type associated with the detector specified for the prediction.
        entities(List): The entity type (associated with the detector's event type) and specific entity ID representing who performed the event. If an entity id is not available, use "UNKNOWN.".
        event_timestamp(str): Timestamp that defines when the event under evaluation occurred.
        event_variables(Dict): Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their corresponding values for the event you are sending for evaluation.    You must provide at least one eventVariable   If detectorVersion is associated with a modelVersion, you must provide at least one associated eventVariable    To ensure highest possible fraud prediction and to simplify your data preparation, Amazon Fraud Detector will replace all missing variables or values as follows:  For Amazon Fraud Detector trained models:  If a null value is provided explicitly for a variable or if a variable is missing, model will replace the null value or the missing variable (no variable name in the eventVariables map) with calculated default mean/medians for numeric variables and with special values for categorical variables.  For External models ( for example, imported SageMaker):  If a null value is provided explicitly for a variable, the model and rules will use “null” as the value. If a variable is not provided (no variable name in the eventVariables map), model and rules will use the default value that is provided for the variable. .
        external_model_endpoint_data_blobs(Dict, optional): The Amazon SageMaker model endpoint input data blobs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.event.prediction.get(
                ctx,
                detector_id=value,
                event_id=value,
                event_type_name=value,
                entities=value,
                event_timestamp=value,
                event_variables=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.event.prediction.get detector_id=value, event_id=value, event_type_name=value, entities=value, event_timestamp=value, event_variables=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="get_event_prediction",
        op_kwargs={
            "detectorId": detector_id,
            "detectorVersionId": detector_version_id,
            "eventId": event_id,
            "eventTypeName": event_type_name,
            "entities": entities,
            "eventTimestamp": event_timestamp,
            "eventVariables": event_variables,
            "externalModelEndpointDataBlobs": external_model_endpoint_data_blobs,
        },
    )
