"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, event_id: str, event_type_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified event. When you delete an event, Amazon Fraud Detector permanently deletes that event and the event data is no longer stored in Amazon Fraud Detector.

    Args:
        event_id(str): The ID of the event to delete.
        event_type_name(str): The name of the event type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.event.init.delete(
                ctx, event_id=value, event_type_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.event.init.delete event_id=value, event_type_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="delete_event",
        op_kwargs={"eventId": event_id, "eventTypeName": event_type_name},
    )
