"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, detector_id: str, detector_version_id: str, status: str
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the detector version’s status. You can perform the following promotions or demotions using UpdateDetectorVersionStatus: DRAFT to ACTIVE, ACTIVE to INACTIVE, and INACTIVE to ACTIVE.

    Args:
        detector_id(str): The detector ID. .
        detector_version_id(str): The detector version ID. .
        status(str): The new status.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.detector.version.status.update(
                ctx, detector_id=value, detector_version_id=value, status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.detector.version.status.update detector_id=value, detector_version_id=value, status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="update_detector_version_status",
        op_kwargs={
            "detectorId": detector_id,
            "detectorVersionId": detector_version_id,
            "status": status,
        },
    )
