"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, detector_id: str, detector_version_id: str, description: str
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the detector version's description. You can update the metadata for any detector version (DRAFT, ACTIVE, or INACTIVE).

    Args:
        detector_id(str): The detector ID.
        detector_version_id(str): The detector version ID. .
        description(str): The description.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.detector.version.metadata.update(
                ctx, detector_id=value, detector_version_id=value, description=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.detector.version.metadata.update detector_id=value, detector_version_id=value, description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="update_detector_version_metadata",
        op_kwargs={
            "detectorId": detector_id,
            "detectorVersionId": detector_version_id,
            "description": description,
        },
    )
