"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    detector_id: str,
    rules: List,
    description: str = None,
    external_model_endpoints: List = None,
    model_versions: List = None,
    rule_execution_mode: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a detector version. The detector version starts in a DRAFT status.

    Args:
        detector_id(str): The ID of the detector under which you want to create a new version.
        description(str, optional): The description of the detector version. Defaults to None.
        external_model_endpoints(List, optional): The Amazon Sagemaker model endpoints to include in the detector version. Defaults to None.
        rules(List): The rules to include in the detector version.
        model_versions(List, optional): The model versions to include in the detector version. Defaults to None.
        rule_execution_mode(str, optional): The rule execution mode for the rules included in the detector version. You can define and edit the rule mode at the detector version level, when it is in draft status. If you specify FIRST_MATCHED, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule. If you specifiy ALL_MATCHED, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules.  The default behavior is FIRST_MATCHED. Defaults to None.
        tags(List, optional): A collection of key and value pairs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.detector.version.init.create(
                ctx, detector_id=value, rules=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.detector.version.init.create detector_id=value, rules=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="create_detector_version",
        op_kwargs={
            "detectorId": detector_id,
            "description": description,
            "externalModelEndpoints": external_model_endpoints,
            "rules": rules,
            "modelVersions": model_versions,
            "ruleExecutionMode": rule_execution_mode,
            "tags": tags,
        },
    )


async def delete(hub, ctx, detector_id: str, detector_version_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the detector version. You cannot delete detector versions that are in ACTIVE status. When you delete a detector version, Amazon Fraud Detector permanently deletes the detector and the data is no longer stored in Amazon Fraud Detector.

    Args:
        detector_id(str): The ID of the parent detector for the detector version to delete.
        detector_version_id(str): The ID of the detector version to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.detector.version.init.delete(
                ctx, detector_id=value, detector_version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.detector.version.init.delete detector_id=value, detector_version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="delete_detector_version",
        op_kwargs={"detectorId": detector_id, "detectorVersionId": detector_version_id},
    )


async def get(hub, ctx, detector_id: str, detector_version_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a particular detector version.

    Args:
        detector_id(str): The detector ID.
        detector_version_id(str): The detector version ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.detector.version.init.get(
                ctx, detector_id=value, detector_version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.detector.version.init.get detector_id=value, detector_version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="get_detector_version",
        op_kwargs={"detectorId": detector_id, "detectorVersionId": detector_version_id},
    )


async def update(
    hub,
    ctx,
    detector_id: str,
    detector_version_id: str,
    external_model_endpoints: List,
    rules: List,
    description: str = None,
    model_versions: List = None,
    rule_execution_mode: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Updates a detector version. The detector version attributes that you can update include models, external model endpoints, rules, rule execution mode, and description. You can only update a DRAFT detector version.

    Args:
        detector_id(str): The parent detector ID for the detector version you want to update.
        detector_version_id(str): The detector version ID. .
        external_model_endpoints(List): The Amazon SageMaker model endpoints to include in the detector version.
        rules(List): The rules to include in the detector version.
        description(str, optional): The detector version description. . Defaults to None.
        model_versions(List, optional): The model versions to include in the detector version. Defaults to None.
        rule_execution_mode(str, optional): The rule execution mode to add to the detector. If you specify FIRST_MATCHED, Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule. If you specifiy ALL_MATCHED, Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft status. The default behavior is FIRST_MATCHED. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.detector.version.init.update(
                ctx,
                detector_id=value,
                detector_version_id=value,
                external_model_endpoints=value,
                rules=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.detector.version.init.update detector_id=value, detector_version_id=value, external_model_endpoints=value, rules=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="update_detector_version",
        op_kwargs={
            "detectorId": detector_id,
            "detectorVersionId": detector_version_id,
            "externalModelEndpoints": external_model_endpoints,
            "rules": rules,
            "description": description,
            "modelVersions": model_versions,
            "ruleExecutionMode": rule_execution_mode,
        },
    )
