"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, detector_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the detector. Before deleting a detector, you must first delete all detector versions and rule versions associated with the detector. When you delete a detector, Amazon Fraud Detector permanently deletes the detector and the data is no longer stored in Amazon Fraud Detector.

    Args:
        detector_id(str): The ID of the detector to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.detector.init.delete(ctx, detector_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.detector.init.delete detector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="delete_detector",
        op_kwargs={"detectorId": detector_id},
    )


async def describe(
    hub, ctx, detector_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets all versions for a specified detector.

    Args:
        detector_id(str): The detector ID.
        next_token(str, optional): The next token from the previous response. Defaults to None.
        max_results(int, optional): The maximum number of results to return for the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.detector.init.describe(ctx, detector_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.detector.init.describe detector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="describe_detector",
        op_kwargs={
            "detectorId": detector_id,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def get_all(
    hub, ctx, detector_id: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets all detectors or a single detector if a detectorId is specified. This is a paginated API. If you provide a null maxResults, this action retrieves a maximum of 10 records per page. If you provide a maxResults, the value must be between 5 and 10. To get the next page results, provide the pagination token from the GetDetectorsResponse as part of your request. A null pagination token fetches the records from the beginning.

    Args:
        detector_id(str, optional): The detector ID. Defaults to None.
        next_token(str, optional): The next token for the subsequent request. Defaults to None.
        max_results(int, optional): The maximum number of objects to return for the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.detector.init.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.detector.init.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="get_detectors",
        op_kwargs={
            "detectorId": detector_id,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def put(
    hub,
    ctx,
    detector_id: str,
    event_type_name: str,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates a detector.

    Args:
        detector_id(str): The detector ID. .
        description(str, optional): The description of the detector. Defaults to None.
        event_type_name(str): The name of the event type.
        tags(List, optional): A collection of key and value pairs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.detector.init.put(
                ctx, detector_id=value, event_type_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.detector.init.put detector_id=value, event_type_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="put_detector",
        op_kwargs={
            "detectorId": detector_id,
            "description": description,
            "eventTypeName": event_type_name,
            "tags": tags,
        },
    )
