"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, variable_entries: List, tags: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a batch of variables.

    Args:
        variable_entries(List): The list of variables for the batch create variable request.
        tags(List, optional): A collection of key and value pairs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.create_variable.batch(ctx, variable_entries=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.create_variable.batch variable_entries=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="batch_create_variable",
        op_kwargs={"variableEntries": variable_entries, "tags": tags},
    )
