"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels the specified batch prediction job.

    Args:
        job_id(str): The ID of the batch prediction job to cancel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.batch_prediction_job.cancel(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.batch_prediction_job.cancel job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="cancel_batch_prediction_job",
        op_kwargs={"jobId": job_id},
    )


async def create(
    hub,
    ctx,
    job_id: str,
    input_path: str,
    output_path: str,
    event_type_name: str,
    detector_name: str,
    iam_role_arn: str,
    detector_version: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a batch prediction job.

    Args:
        job_id(str): The ID of the batch prediction job.
        input_path(str): The Amazon S3 location of your training file.
        output_path(str): The Amazon S3 location of your output file.
        event_type_name(str): The name of the event type.
        detector_name(str): The name of the detector.
        detector_version(str, optional): The detector version. Defaults to None.
        iam_role_arn(str): The ARN of the IAM role to use for this job request.
        tags(List, optional): A collection of key and value pairs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.batch_prediction_job.create(
                ctx,
                job_id=value,
                input_path=value,
                output_path=value,
                event_type_name=value,
                detector_name=value,
                iam_role_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.batch_prediction_job.create job_id=value, input_path=value, output_path=value, event_type_name=value, detector_name=value, iam_role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="create_batch_prediction_job",
        op_kwargs={
            "jobId": job_id,
            "inputPath": input_path,
            "outputPath": output_path,
            "eventTypeName": event_type_name,
            "detectorName": detector_name,
            "detectorVersion": detector_version,
            "iamRoleArn": iam_role_arn,
            "tags": tags,
        },
    )


async def delete(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a batch prediction job.

    Args:
        job_id(str): The ID of the batch prediction job to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.batch_prediction_job.delete(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.batch_prediction_job.delete job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="delete_batch_prediction_job",
        op_kwargs={"jobId": job_id},
    )


async def get_all(
    hub, ctx, job_id: str = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets all batch prediction jobs or a specific job if you specify a job ID. This is a paginated API. If you provide a null maxResults, this action retrieves a maximum of 50 records per page. If you provide a maxResults, the value must be between 1 and 50. To get the next page results, provide the pagination token from the GetBatchPredictionJobsResponse as part of your request. A null pagination token fetches the records from the beginning.

    Args:
        job_id(str, optional): The batch prediction job for which to get the details. Defaults to None.
        max_results(int, optional): The maximum number of objects to return for the request. Defaults to None.
        next_token(str, optional): The next token from the previous request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.frauddetector.batch_prediction_job.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.frauddetector.batch_prediction_job.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="frauddetector",
        operation="get_batch_prediction_jobs",
        op_kwargs={"jobId": job_id, "maxResults": max_results, "nextToken": next_token},
    )
