"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def query(
    hub,
    ctx,
    forecast_arn: str,
    filters: Dict,
    start_date: str = None,
    end_date: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a forecast for a single item, filtered by the supplied criteria. The criteria is a key-value pair. The key is either item_id (or the equivalent non-timestamp, non-target field) from the TARGET_TIME_SERIES dataset, or one of the forecast dimensions specified as part of the FeaturizationConfig object. By default, QueryForecast returns the complete date range for the filtered forecast. You can request a specific date range. To get the full forecast, use the CreateForecastExportJob operation.  The forecasts generated by Amazon Forecast are in the same timezone as the dataset that was used to create the predictor.

    Args:
        forecast_arn(str): The Amazon Resource Name (ARN) of the forecast to query.
        start_date(str, optional): The start date for the forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss (ISO 8601 format). For example, 2015-01-01T08:00:00. Defaults to None.
        end_date(str, optional): The end date for the forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss (ISO 8601 format). For example, 2015-01-01T20:00:00. . Defaults to None.
        filters(Dict): The filtering criteria to apply when retrieving the forecast. For example, to get the forecast for client_21 in the electricity usage dataset, specify the following:  {"item_id" : "client_21"}  To get the full forecast, use the CreateForecastExportJob operation.
        next_token(str, optional): If the result of the previous request was truncated, the response includes a NextToken. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecastquery_forecast.query(
                ctx, forecast_arn=value, filters=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecastquery_forecast.query forecast_arn=value, filters=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecastquery",
        operation="query_forecast",
        op_kwargs={
            "ForecastArn": forecast_arn,
            "StartDate": start_date,
            "EndDate": end_date,
            "Filters": filters,
            "NextToken": next_token,
        },
    )
