"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def delete(hub, ctx, resource_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an entire resource tree. This operation will delete the parent resource and its child resources. Child resources are resources that were created from another resource. For example, when a forecast is generated from a predictor, the forecast is the child resource and the predictor is the parent resource. Amazon Forecast resources possess the following parent-child resource hierarchies:    Dataset: dataset import jobs    Dataset Group: predictors, predictor backtest export jobs, forecasts, forecast export jobs    Predictor: predictor backtest export jobs, forecasts, forecast export jobs    Forecast: forecast export jobs     DeleteResourceTree will only delete Amazon Forecast resources, and will not delete datasets or exported files stored in Amazon S3.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the parent resource to delete. All child resources of the parent resource will also be deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecast.resource.tree.delete(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecast.resource.tree.delete resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecast",
        operation="delete_resource_tree",
        op_kwargs={"ResourceArn": resource_arn},
    )
