"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    predictor_backtest_export_job_name: str,
    predictor_arn: str,
    destination: Dict,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Exports backtest forecasts and accuracy metrics generated by the CreatePredictor operation. Two folders containing CSV files are exported to your specified S3 bucket.  The export file names will match the following conventions:  <ExportJobName>_<ExportTimestamp>_<PartNumber>.csv  The <ExportTimestamp> component is in Java SimpleDate format (yyyy-MM-ddTHH-mm-ssZ). You must specify a DataDestination object that includes an Amazon S3 bucket and an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket. For more information, see aws-forecast-iam-roles.  The Status of the export job must be ACTIVE before you can access the export in your Amazon S3 bucket. To get the status, use the DescribePredictorBacktestExportJob operation.

    Args:
        predictor_backtest_export_job_name(str): The name for the backtest export job.
        predictor_arn(str): The Amazon Resource Name (ARN) of the predictor that you want to export.
        destination(Dict): The destination for an export job. Provide an S3 path, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast to access the location, and an AWS Key Management Service (KMS) key (optional). .
        tags(List, optional): Optional metadata to help you categorize and organize your backtests. Each tag consists of a key and an optional value, both of which you define. Tag keys and values are case sensitive. The following restrictions apply to tags:   For each resource, each tag key must be unique and each tag key must have one value.   Maximum number of tags per resource: 50.   Maximum key length: 128 Unicode characters in UTF-8.   Maximum value length: 256 Unicode characters in UTF-8.   Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your tagging schema is used across other services and resources, the character restrictions of those services also apply.    Key prefixes cannot include any upper or lowercase combination of aws: or AWS:. Values can have this prefix. If a tag value has aws as its prefix but the key does not, Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit. You cannot edit or delete tag keys with this prefix.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecast.predictor.backtest_export_job.create(
                ctx,
                predictor_backtest_export_job_name=value,
                predictor_arn=value,
                destination=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecast.predictor.backtest_export_job.create predictor_backtest_export_job_name=value, predictor_arn=value, destination=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecast",
        operation="create_predictor_backtest_export_job",
        op_kwargs={
            "PredictorBacktestExportJobName": predictor_backtest_export_job_name,
            "PredictorArn": predictor_arn,
            "Destination": destination,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, predictor_backtest_export_job_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a predictor backtest export job.

    Args:
        predictor_backtest_export_job_arn(str): The Amazon Resource Name (ARN) of the predictor backtest export job to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecast.predictor.backtest_export_job.delete(
                ctx, predictor_backtest_export_job_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecast.predictor.backtest_export_job.delete predictor_backtest_export_job_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecast",
        operation="delete_predictor_backtest_export_job",
        op_kwargs={"PredictorBacktestExportJobArn": predictor_backtest_export_job_arn},
    )


async def describe(hub, ctx, predictor_backtest_export_job_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a predictor backtest export job created using the CreatePredictorBacktestExportJob operation. In addition to listing the properties provided by the user in the CreatePredictorBacktestExportJob request, this operation lists the following properties:    CreationTime     LastModificationTime     Status     Message (if an error occurred)

    Args:
        predictor_backtest_export_job_arn(str): The Amazon Resource Name (ARN) of the predictor backtest export job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecast.predictor.backtest_export_job.describe(
                ctx, predictor_backtest_export_job_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecast.predictor.backtest_export_job.describe predictor_backtest_export_job_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecast",
        operation="describe_predictor_backtest_export_job",
        op_kwargs={"PredictorBacktestExportJobArn": predictor_backtest_export_job_arn},
    )


async def list_all(
    hub, ctx, next_token: str = None, max_results: int = None, filters: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of predictor backtest export jobs created using the CreatePredictorBacktestExportJob operation. This operation returns a summary for each backtest export job. You can filter the list using an array of Filter objects. To retrieve the complete set of properties for a particular backtest export job, use the ARN with the DescribePredictorBacktestExportJob operation.

    Args:
        next_token(str, optional): If the result of the previous request was truncated, the response includes a NextToken. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours. Defaults to None.
        max_results(int, optional): The number of items to return in the response. Defaults to None.
        filters(List, optional): An array of filters. For each filter, provide a condition and a match statement. The condition is either IS or IS_NOT, which specifies whether to include or exclude the predictor backtest export jobs that match the statement from the list. The match statement consists of a key and a value.  Filter properties     Condition - The condition to apply. Valid values are IS and IS_NOT. To include the predictor backtest export jobs that match the statement, specify IS. To exclude matching predictor backtest export jobs, specify IS_NOT.    Key - The name of the parameter to filter on. Valid values are PredictorArn and Status.    Value - The value to match.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecast.predictor.backtest_export_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecast.predictor.backtest_export_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecast",
        operation="list_predictor_backtest_export_jobs",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "Filters": filters,
        },
    )
