"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    forecast_name: str,
    predictor_arn: str,
    forecast_types: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a forecast for each item in the TARGET_TIME_SERIES dataset that was used to train the predictor. This is known as inference. To retrieve the forecast for a single item at low latency, use the operation. To export the complete forecast into your Amazon Simple Storage Service (Amazon S3) bucket, use the CreateForecastExportJob operation. The range of the forecast is determined by the ForecastHorizon value, which you specify in the CreatePredictor request. When you query a forecast, you can request a specific date range within the forecast. To get a list of all your forecasts, use the ListForecasts operation.  The forecasts generated by Amazon Forecast are in the same time zone as the dataset that was used to create the predictor.  For more information, see howitworks-forecast.  The Status of the forecast must be ACTIVE before you can query or export the forecast. Use the DescribeForecast operation to get the status.

    Args:
        forecast_name(str): A name for the forecast.
        predictor_arn(str): The Amazon Resource Name (ARN) of the predictor to use to generate the forecast.
        forecast_types(List, optional): The quantiles at which probabilistic forecasts are generated. You can currently specify up to 5 quantiles per forecast. Accepted values include 0.01 to 0.99 (increments of .01 only) and mean. The mean forecast is different from the median (0.50) when the distribution is not symmetric (for example, Beta and Negative Binomial). The default value is ["0.1", "0.5", "0.9"]. Defaults to None.
        tags(List, optional): The optional metadata that you apply to the forecast to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. The following basic restrictions apply to tags:   Maximum number of tags per resource - 50.   For each resource, each tag key must be unique, and each tag key can have only one value.   Maximum key length - 128 Unicode characters in UTF-8.   Maximum value length - 256 Unicode characters in UTF-8.   If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.   Tag keys and values are case sensitive.   Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecast.forecast.init.create(
                ctx, forecast_name=value, predictor_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecast.forecast.init.create forecast_name=value, predictor_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecast",
        operation="create_forecast",
        op_kwargs={
            "ForecastName": forecast_name,
            "PredictorArn": predictor_arn,
            "ForecastTypes": forecast_types,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, forecast_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a forecast created using the CreateForecast operation. You can delete only forecasts that have a status of ACTIVE or CREATE_FAILED. To get the status, use the DescribeForecast operation. You can't delete a forecast while it is being exported. After a forecast is deleted, you can no longer query the forecast.

    Args:
        forecast_arn(str): The Amazon Resource Name (ARN) of the forecast to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecast.forecast.init.delete(ctx, forecast_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecast.forecast.init.delete forecast_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecast",
        operation="delete_forecast",
        op_kwargs={"ForecastArn": forecast_arn},
    )


async def describe(hub, ctx, forecast_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a forecast created using the CreateForecast operation. In addition to listing the properties provided in the CreateForecast request, this operation lists the following properties:    DatasetGroupArn - The dataset group that provided the training data.    CreationTime     LastModificationTime     Status     Message - If an error occurred, information about the error.

    Args:
        forecast_arn(str): The Amazon Resource Name (ARN) of the forecast.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecast.forecast.init.describe(ctx, forecast_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecast.forecast.init.describe forecast_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecast",
        operation="describe_forecast",
        op_kwargs={"ForecastArn": forecast_arn},
    )


async def list_all(
    hub, ctx, next_token: str = None, max_results: int = None, filters: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of forecasts created using the CreateForecast operation. For each forecast, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). To retrieve the complete set of properties, specify the ARN with the DescribeForecast operation. You can filter the list using an array of Filter objects.

    Args:
        next_token(str, optional): If the result of the previous request was truncated, the response includes a NextToken. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours. Defaults to None.
        max_results(int, optional): The number of items to return in the response. Defaults to None.
        filters(List, optional): An array of filters. For each filter, you provide a condition and a match statement. The condition is either IS or IS_NOT, which specifies whether to include or exclude the forecasts that match the statement from the list, respectively. The match statement consists of a key and a value.  Filter properties     Condition - The condition to apply. Valid values are IS and IS_NOT. To include the forecasts that match the statement, specify IS. To exclude matching forecasts, specify IS_NOT.    Key - The name of the parameter to filter on. Valid values are DatasetGroupArn, PredictorArn, and Status.    Value - The value to match.   For example, to list all forecasts whose status is not ACTIVE, you would specify:  "Filters": [ { "Condition": "IS_NOT", "Key": "Status", "Value": "ACTIVE" } ] . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecast.forecast.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecast.forecast.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecast",
        operation="list_forecasts",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "Filters": filters,
        },
    )
