"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    forecast_export_job_name: str,
    forecast_arn: str,
    destination: Dict,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Exports a forecast created by the CreateForecast operation to your Amazon Simple Storage Service (Amazon S3) bucket. The forecast file name will match the following conventions: <ForecastExportJobName>_<ExportTimestamp>_<PartNumber> where the <ExportTimestamp> component is in Java SimpleDateFormat (yyyy-MM-ddTHH-mm-ssZ). You must specify a DataDestination object that includes an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket. For more information, see aws-forecast-iam-roles. For more information, see howitworks-forecast. To get a list of all your forecast export jobs, use the ListForecastExportJobs operation.  The Status of the forecast export job must be ACTIVE before you can access the forecast in your Amazon S3 bucket. To get the status, use the DescribeForecastExportJob operation.

    Args:
        forecast_export_job_name(str): The name for the forecast export job.
        forecast_arn(str): The Amazon Resource Name (ARN) of the forecast that you want to export.
        destination(Dict): The location where you want to save the forecast and an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the location. The forecast must be exported to an Amazon S3 bucket. If encryption is used, Destination must include an AWS Key Management Service (KMS) key. The IAM role must allow Amazon Forecast permission to access the key.
        tags(List, optional): The optional metadata that you apply to the forecast export job to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. The following basic restrictions apply to tags:   Maximum number of tags per resource - 50.   For each resource, each tag key must be unique, and each tag key can have only one value.   Maximum key length - 128 Unicode characters in UTF-8.   Maximum value length - 256 Unicode characters in UTF-8.   If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.   Tag keys and values are case sensitive.   Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecast.forecast.export_job.create(
                ctx, forecast_export_job_name=value, forecast_arn=value, destination=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecast.forecast.export_job.create forecast_export_job_name=value, forecast_arn=value, destination=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecast",
        operation="create_forecast_export_job",
        op_kwargs={
            "ForecastExportJobName": forecast_export_job_name,
            "ForecastArn": forecast_arn,
            "Destination": destination,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, forecast_export_job_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a forecast export job created using the CreateForecastExportJob operation. You can delete only export jobs that have a status of ACTIVE or CREATE_FAILED. To get the status, use the DescribeForecastExportJob operation.

    Args:
        forecast_export_job_arn(str): The Amazon Resource Name (ARN) of the forecast export job to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecast.forecast.export_job.delete(
                ctx, forecast_export_job_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecast.forecast.export_job.delete forecast_export_job_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecast",
        operation="delete_forecast_export_job",
        op_kwargs={"ForecastExportJobArn": forecast_export_job_arn},
    )


async def describe(hub, ctx, forecast_export_job_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a forecast export job created using the CreateForecastExportJob operation. In addition to listing the properties provided by the user in the CreateForecastExportJob request, this operation lists the following properties:    CreationTime     LastModificationTime     Status     Message - If an error occurred, information about the error.

    Args:
        forecast_export_job_arn(str): The Amazon Resource Name (ARN) of the forecast export job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecast.forecast.export_job.describe(
                ctx, forecast_export_job_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecast.forecast.export_job.describe forecast_export_job_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecast",
        operation="describe_forecast_export_job",
        op_kwargs={"ForecastExportJobArn": forecast_export_job_arn},
    )


async def list_all(
    hub, ctx, next_token: str = None, max_results: int = None, filters: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of forecast export jobs created using the CreateForecastExportJob operation. For each forecast export job, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). To retrieve the complete set of properties, use the ARN with the DescribeForecastExportJob operation. You can filter the list using an array of Filter objects.

    Args:
        next_token(str, optional): If the result of the previous request was truncated, the response includes a NextToken. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours. Defaults to None.
        max_results(int, optional): The number of items to return in the response. Defaults to None.
        filters(List, optional): An array of filters. For each filter, you provide a condition and a match statement. The condition is either IS or IS_NOT, which specifies whether to include or exclude the forecast export jobs that match the statement from the list, respectively. The match statement consists of a key and a value.  Filter properties     Condition - The condition to apply. Valid values are IS and IS_NOT. To include the forecast export jobs that match the statement, specify IS. To exclude matching forecast export jobs, specify IS_NOT.    Key - The name of the parameter to filter on. Valid values are ForecastArn and Status.    Value - The value to match.   For example, to list all jobs that export a forecast named electricityforecast, specify the following filter:  "Filters": [ { "Condition": "IS", "Key": "ForecastArn", "Value": "arn:aws:forecast:us-west-2:<acct-id>:forecast/electricityforecast" } ] . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecast.forecast.export_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecast.forecast.export_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecast",
        operation="list_forecast_export_jobs",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "Filters": filters,
        },
    )
