"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    dataset_group_name: str,
    domain: str,
    dataset_arns: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a dataset group, which holds a collection of related datasets. You can add datasets to the dataset group when you create the dataset group, or later by using the UpdateDatasetGroup operation. After creating a dataset group and adding datasets, you use the dataset group when you create a predictor. For more information, see howitworks-datasets-groups. To get a list of all your datasets groups, use the ListDatasetGroups operation.  The Status of a dataset group must be ACTIVE before you can use the dataset group to create a predictor. To get the status, use the DescribeDatasetGroup operation.

    Args:
        dataset_group_name(str): A name for the dataset group.
        domain(str): The domain associated with the dataset group. When you add a dataset to a dataset group, this value and the value specified for the Domain parameter of the CreateDataset operation must match. The Domain and DatasetType that you choose determine the fields that must be present in training data that you import to a dataset. For example, if you choose the RETAIL domain and TARGET_TIME_SERIES as the DatasetType, Amazon Forecast requires that item_id, timestamp, and demand fields are present in your data. For more information, see howitworks-datasets-groups.
        dataset_arns(List, optional): An array of Amazon Resource Names (ARNs) of the datasets that you want to include in the dataset group. Defaults to None.
        tags(List, optional): The optional metadata that you apply to the dataset group to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. The following basic restrictions apply to tags:   Maximum number of tags per resource - 50.   For each resource, each tag key must be unique, and each tag key can have only one value.   Maximum key length - 128 Unicode characters in UTF-8.   Maximum value length - 256 Unicode characters in UTF-8.   If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.   Tag keys and values are case sensitive.   Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecast.dataset.group.create(
                ctx, dataset_group_name=value, domain=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecast.dataset.group.create dataset_group_name=value, domain=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecast",
        operation="create_dataset_group",
        op_kwargs={
            "DatasetGroupName": dataset_group_name,
            "Domain": domain,
            "DatasetArns": dataset_arns,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, dataset_group_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a dataset group created using the CreateDatasetGroup operation. You can only delete dataset groups that have a status of ACTIVE, CREATE_FAILED, or UPDATE_FAILED. To get the status, use the DescribeDatasetGroup operation. This operation deletes only the dataset group, not the datasets in the group.

    Args:
        dataset_group_arn(str): The Amazon Resource Name (ARN) of the dataset group to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecast.dataset.group.delete(ctx, dataset_group_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecast.dataset.group.delete dataset_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecast",
        operation="delete_dataset_group",
        op_kwargs={"DatasetGroupArn": dataset_group_arn},
    )


async def describe(hub, ctx, dataset_group_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a dataset group created using the CreateDatasetGroup operation. In addition to listing the parameters provided in the CreateDatasetGroup request, this operation includes the following properties:    DatasetArns - The datasets belonging to the group.    CreationTime     LastModificationTime     Status

    Args:
        dataset_group_arn(str): The Amazon Resource Name (ARN) of the dataset group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecast.dataset.group.describe(ctx, dataset_group_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecast.dataset.group.describe dataset_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecast",
        operation="describe_dataset_group",
        op_kwargs={"DatasetGroupArn": dataset_group_arn},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of dataset groups created using the CreateDatasetGroup operation. For each dataset group, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the dataset group ARN with the DescribeDatasetGroup operation.

    Args:
        next_token(str, optional): If the result of the previous request was truncated, the response includes a NextToken. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours. Defaults to None.
        max_results(int, optional): The number of items to return in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecast.dataset.group.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecast.dataset.group.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecast",
        operation="list_dataset_groups",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(hub, ctx, dataset_group_arn: str, dataset_arns: List) -> Dict:
    r"""
    **Autogenerated function**

    Replaces the datasets in a dataset group with the specified datasets.  The Status of the dataset group must be ACTIVE before you can use the dataset group to create a predictor. Use the DescribeDatasetGroup operation to get the status.

    Args:
        dataset_group_arn(str): The ARN of the dataset group.
        dataset_arns(List): An array of the Amazon Resource Names (ARNs) of the datasets to add to the dataset group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.forecast.dataset.group.update(
                ctx, dataset_group_arn=value, dataset_arns=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.forecast.dataset.group.update dataset_group_arn=value, dataset_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="forecast",
        operation="update_dataset_group",
        op_kwargs={"DatasetGroupArn": dataset_group_arn, "DatasetArns": dataset_arns},
    )
