"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub, ctx, policy_id: str, member_account: str, resource_id: str, resource_type: str
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves violations for a resource based on the specified Firewall Manager policy and Amazon Web Services account.

    Args:
        policy_id(str): The ID of the Firewall Manager policy that you want the details for. This currently only supports security group content audit policies.
        member_account(str): The Amazon Web Services account ID that you want the details for.
        resource_id(str): The ID of the resource that has violations.
        resource_type(str): The resource type. This is in the format shown in the Amazon Web Services Resource Types Reference. Supported resource types are: AWS::EC2::Instance, AWS::EC2::NetworkInterface, AWS::EC2::SecurityGroup, AWS::NetworkFirewall::FirewallPolicy, and AWS::EC2::Subnet. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.violation_detail.get_all(
                ctx, policy_id=value, member_account=value, resource_id=value, resource_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.violation_detail.get_all policy_id=value, member_account=value, resource_id=value, resource_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fms",
        operation="get_violation_details",
        op_kwargs={
            "PolicyId": policy_id,
            "MemberAccount": member_account,
            "ResourceId": resource_id,
            "ResourceType": resource_type,
        },
    )
