"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, resource_arn: str, tag_list: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds one or more tags to an Amazon Web Services resource.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the resource to return tags for. The Firewall Manager resources that support tagging are policies, applications lists, and protocols lists. .
        tag_list(List): The tags to add to the resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.resource.tag(ctx, resource_arn=value, tag_list=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.resource.tag resource_arn=value, tag_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fms",
        operation="tag_resource",
        op_kwargs={"ResourceArn": resource_arn, "TagList": tag_list},
    )


async def untag(hub, ctx, resource_arn: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes one or more tags from an Amazon Web Services resource.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the resource to return tags for. The Firewall Manager resources that support tagging are policies, applications lists, and protocols lists. .
        tag_keys(List): The keys of the tags to remove from the resource. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.resource.untag(ctx, resource_arn=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.resource.untag resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fms",
        operation="untag_resource",
        op_kwargs={"ResourceArn": resource_arn, "TagKeys": tag_keys},
    )
