"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    policy_id: str,
    member_account_id: str = None,
    start_time: str = None,
    end_time: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    If you created a Shield Advanced policy, returns policy-level attack summary information in the event of a potential DDoS attack. Other policy types are currently unsupported.

    Args:
        policy_id(str): The ID of the policy for which you want to get the attack information.
        member_account_id(str, optional): The Amazon Web Services account that is in scope of the policy that you want to get the details for. Defaults to None.
        start_time(str, optional): The start of the time period to query for the attacks. This is a timestamp type. The request syntax listing indicates a number type because the default used by Firewall Manager is Unix time in seconds. However, any valid timestamp format is allowed. Defaults to None.
        end_time(str, optional): The end of the time period to query for the attacks. This is a timestamp type. The request syntax listing indicates a number type because the default used by Firewall Manager is Unix time in seconds. However, any valid timestamp format is allowed. Defaults to None.
        next_token(str, optional): If you specify a value for MaxResults and you have more objects than the number that you specify for MaxResults, Firewall Manager returns a NextToken value in the response, which you can use to retrieve another group of objects. For the second and subsequent GetProtectionStatus requests, specify the value of NextToken from the previous response to get information about another batch of objects. Defaults to None.
        max_results(int, optional): Specifies the number of objects that you want Firewall Manager to return for this request. If you have more objects than the number that you specify for MaxResults, the response includes a NextToken value that you can use to get another batch of objects. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.protection_status.get(ctx, policy_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.protection_status.get policy_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fms",
        operation="get_protection_status",
        op_kwargs={
            "PolicyId": policy_id,
            "MemberAccountId": member_account_id,
            "StartTime": start_time,
            "EndTime": end_time,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
