"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub, ctx, policy_id: str, delete_all_policy_resources: bool = None
) -> None:
    r"""
    **Autogenerated function**

    Permanently deletes an Firewall Manager policy.

    Args:
        policy_id(str): The ID of the policy that you want to delete. You can retrieve this ID from PutPolicy and ListPolicies.
        delete_all_policy_resources(bool, optional): If True, the request performs cleanup according to the policy type.  For WAF and Shield Advanced policies, the cleanup does the following:   Deletes rule groups created by Firewall Manager   Removes web ACLs from in-scope resources   Deletes web ACLs that contain no rules or rule groups   For security group policies, the cleanup does the following for each security group in the policy:   Disassociates the security group from in-scope resources    Deletes the security group if it was created through Firewall Manager and if it's no longer associated with any resources through another policy   After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection of out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts that you associate with the policy. When creating the policy, if you specify that only resources in specific accounts or with specific tags are in scope of the policy, those accounts and resources are handled by the policy. All others are out of scope. If you don't specify tags or accounts, all resources are in scope. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.policy.delete(ctx, policy_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.policy.delete policy_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fms",
        operation="delete_policy",
        op_kwargs={
            "PolicyId": policy_id,
            "DeleteAllPolicyResources": delete_all_policy_resources,
        },
    )


async def get(hub, ctx, policy_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the specified Firewall Manager policy.

    Args:
        policy_id(str): The ID of the Firewall Manager policy that you want the details for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.policy.get(ctx, policy_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.policy.get policy_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fms",
        operation="get_policy",
        op_kwargs={"PolicyId": policy_id},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of PolicySummary objects.

    Args:
        next_token(str, optional): If you specify a value for MaxResults and you have more PolicySummary objects than the number that you specify for MaxResults, Firewall Manager returns a NextToken value in the response that allows you to list another group of PolicySummary objects. For the second and subsequent ListPolicies requests, specify the value of NextToken from the previous response to get information about another batch of PolicySummary objects. Defaults to None.
        max_results(int, optional): Specifies the number of PolicySummary objects that you want Firewall Manager to return for this request. If you have more PolicySummary objects than the number that you specify for MaxResults, the response includes a NextToken value that you can use to get another batch of PolicySummary objects. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.policy.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.policy.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fms",
        operation="list_policies",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def put(hub, ctx, policy: Dict, tag_list: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Firewall Manager policy. Firewall Manager provides the following types of policies:    An WAF policy (type WAFV2), which defines rule groups to run first in the corresponding WAF web ACL and rule groups to run last in the web ACL.   An WAF Classic policy (type WAF), which defines a rule group.    A Shield Advanced policy, which applies Shield Advanced protection to specified accounts and resources.   A security group policy, which manages VPC security groups across your Amazon Web Services organization.    An Network Firewall policy, which provides firewall rules to filter network traffic in specified Amazon VPCs.   A DNS Firewall policy, which provides Route 53 Resolver DNS Firewall rules to filter DNS queries for specified VPCs.   Each policy is specific to one of the types. If you want to enforce more than one policy type across accounts, create multiple policies. You can create multiple policies for each type. You must be subscribed to Shield Advanced to create a Shield Advanced policy. For more information about subscribing to Shield Advanced, see CreateSubscription.

    Args:
        policy(Dict): The details of the Firewall Manager policy to be created.
        tag_list(List, optional): The tags to add to the Amazon Web Services resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.policy.put(ctx, policy=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.policy.put policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fms",
        operation="put_policy",
        op_kwargs={"Policy": policy, "TagList": tag_list},
    )
