"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx) -> None:
    r"""
    **Autogenerated function**

    Deletes an Firewall Manager association with the IAM role and the Amazon Simple Notification Service (SNS) topic that is used to record Firewall Manager SNS logs.

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.notification_channel.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.notification_channel.delete
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="fms", operation="delete_notification_channel", op_kwargs={}
    )


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Information about the Amazon Simple Notification Service (SNS) topic that is used to record Firewall Manager SNS logs.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.notification_channel.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.notification_channel.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="fms", operation="get_notification_channel", op_kwargs={}
    )


async def put(hub, ctx, sns_topic_arn: str, sns_role_name: str) -> None:
    r"""
    **Autogenerated function**

    Designates the IAM role and Amazon Simple Notification Service (SNS) topic that Firewall Manager uses to record SNS logs. To perform this action outside of the console, you must configure the SNS topic to allow the Firewall Manager role AWSServiceRoleForFMS to publish SNS logs. For more information, see Firewall Manager required permissions for API actions in the Firewall Manager Developer Guide.

    Args:
        sns_topic_arn(str): The Amazon Resource Name (ARN) of the SNS topic that collects notifications from Firewall Manager.
        sns_role_name(str): The Amazon Resource Name (ARN) of the IAM role that allows Amazon SNS to record Firewall Manager activity. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.notification_channel.put(
                ctx, sns_topic_arn=value, sns_role_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.notification_channel.put sns_topic_arn=value, sns_role_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fms",
        operation="put_notification_channel",
        op_kwargs={"SnsTopicArn": sns_topic_arn, "SnsRoleName": sns_role_name},
    )
