"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, policy_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of PolicyComplianceStatus objects. Use PolicyComplianceStatus to get a summary of which member accounts are protected by the specified policy.

    Args:
        policy_id(str): The ID of the Firewall Manager policy that you want the details for.
        next_token(str, optional): If you specify a value for MaxResults and you have more PolicyComplianceStatus objects than the number that you specify for MaxResults, Firewall Manager returns a NextToken value in the response that allows you to list another group of PolicyComplianceStatus objects. For the second and subsequent ListComplianceStatus requests, specify the value of NextToken from the previous response to get information about another batch of PolicyComplianceStatus objects. Defaults to None.
        max_results(int, optional): Specifies the number of PolicyComplianceStatus objects that you want Firewall Manager to return for this request. If you have more PolicyComplianceStatus objects than the number that you specify for MaxResults, the response includes a NextToken value that you can use to get another batch of PolicyComplianceStatus objects. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.compliance.status.list(ctx, policy_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.compliance.status.list policy_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fms",
        operation="list_compliance_status",
        op_kwargs={
            "PolicyId": policy_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
